<?php
/**
 * Script para agregar columnas faltantes en menu_permissions
 * Ejecutar desde: http://localhost/hogar_abuelos/fix_columnas_menu_permissions.php
 */

require 'backend/bd/Conexion.php';

echo "<!DOCTYPE html>";
echo "<html><head>";
echo "<meta charset='UTF-8'>";
echo "<style>
    body { font-family: Arial; padding: 20px; background: #f5f5f5; }
    .container { max-width: 900px; margin: 0 auto; background: white; padding: 30px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
    h1 { color: #667eea; }
    .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 10px 0; }
    .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; margin: 10px 0; }
    .warning { background: #fff3cd; color: #856404; padding: 15px; border-radius: 8px; margin: 10px 0; }
    .info { background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 8px; margin: 10px 0; }
</style>";
echo "</head><body><div class='container'>";

echo "<h1>🔧 Agregar Columnas Faltantes en menu_permissions</h1>";

try {
    // Obtener columnas existentes
    $columnsStmt = $connect->query("SHOW COLUMNS FROM menu_permissions");
    $existingColumns = $columnsStmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Columnas necesarias para el sistema
    $requiredColumns = [
        'usuarios_lista' => 'TINYINT(1) DEFAULT 0',
        'usuarios_historial' => 'TINYINT(1) DEFAULT 0',
        'usuarios_documentos' => 'TINYINT(1) DEFAULT 0',
        'profesionales_lista' => 'TINYINT(1) DEFAULT 0',
        'profesionales_historial' => 'TINYINT(1) DEFAULT 0'
    ];
    
    $added = 0;
    $skipped = 0;
    $errors = [];
    
    echo "<h2>Verificando columnas...</h2>";
    
    foreach($requiredColumns as $column => $definition) {
        if(!in_array($column, $existingColumns)) {
            // La columna no existe, agregarla
            try {
                $sql = "ALTER TABLE menu_permissions ADD COLUMN $column $definition";
                $connect->exec($sql);
                echo "<div class='success'>✅ Columna agregada: <strong>$column</strong></div>";
                $added++;
            } catch(PDOException $e) {
                echo "<div class='error'>❌ Error al agregar <strong>$column</strong>: " . $e->getMessage() . "</div>";
                $errors[] = $column;
            }
        } else {
            echo "<div class='info'>ℹ️ La columna <strong>$column</strong> ya existe</div>";
            $skipped++;
        }
    }
    
    echo "<hr>";
    echo "<h2>Resumen:</h2>";
    echo "<div class='info'>";
    echo "<ul>";
    echo "<li>✅ Columnas agregadas: <strong>$added</strong></li>";
    echo "<li>ℹ️ Columnas que ya existían: <strong>$skipped</strong></li>";
    echo "<li>❌ Errores: <strong>" . count($errors) . "</strong></li>";
    echo "</ul>";
    echo "</div>";
    
    if($added > 0) {
        echo "<div class='success'>";
        echo "<h3>🎉 ¡Columnas agregadas exitosamente!</h3>";
        echo "<p>Ahora puedes:</p>";
        echo "<ol>";
        echo "<li>Ir a la lista de profesionales</li>";
        echo "<li>Editar los permisos del usuario de enfermería</li>";
        echo "<li>Asignar los permisos necesarios</li>";
        echo "</ol>";
        echo "<a href='frontend/medicos/mostrar.php' style='display: inline-block; padding: 10px 20px; background: #667eea; color: white; text-decoration: none; border-radius: 6px; margin-top: 10px;'>Ir a Profesionales</a>";
        echo "</div>";
    }
    
    if(count($errors) > 0) {
        echo "<div class='error'>";
        echo "<h3>⚠️ Se encontraron errores</h3>";
        echo "<p>Las siguientes columnas no pudieron ser agregadas:</p>";
        echo "<ul>";
        foreach($errors as $errCol) {
            echo "<li>$errCol</li>";
        }
        echo "</ul>";
        echo "</div>";
    }
    
    echo "<div style='margin-top: 30px; text-align: center;'>";
    echo "<a href='debug_permisos_enfermeria.php' style='display: inline-block; padding: 10px 20px; background: #17a2b8; color: white; text-decoration: none; border-radius: 6px;'>Ver Debug de Permisos</a>";
    echo "</div>";
    
} catch(PDOException $e) {
    echo "<div class='error'><strong>Error Fatal:</strong> " . $e->getMessage() . "</div>";
}

echo "</div></body></html>";
?>
