<?php
require 'backend/bd/Conexion.php';

echo "<h1>Forzar Actualización de Permisos - racosta</h1>";

try {
    // 1. Obtener ID de racosta
    $userStmt = $connect->prepare("SELECT id, username, rol FROM users WHERE username = 'racosta'");
    $userStmt->execute();
    $user = $userStmt->fetch(PDO::FETCH_ASSOC);
    
    if(!$user) {
        echo "<p style='color: red;'>❌ Usuario racosta no encontrado</p>";
        exit();
    }
    
    echo "<h2>Usuario Encontrado:</h2>";
    echo "<p>ID: {$user['id']}</p>";
    echo "<p>Username: {$user['username']}</p>";
    echo "<p>Rol: {$user['rol']}</p>";
    
    // 2. Verificar si tiene registro en menu_permissions
    $checkStmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
    $checkStmt->execute([$user['id']]);
    $existing = $checkStmt->fetch(PDO::FETCH_ASSOC);
    
    if($existing) {
        echo "<h2>Registro Actual en menu_permissions:</h2>";
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Columna</th><th>Valor</th></tr>";
        foreach($existing as $key => $value) {
            echo "<tr><td>$key</td><td>$value</td></tr>";
        }
        echo "</table>";
        
        // 3. ACTUALIZAR forzando solo Dashboard, Cursos y Acerca de
        echo "<h2>Actualizando Permisos...</h2>";
        
        // Obtener columnas existentes
        $columns = $connect->query("SHOW COLUMNS FROM menu_permissions")->fetchAll(PDO::FETCH_COLUMN);
        
        $updateParts = [];
        $updateParams = [];
        
        // Mapeo: solo Dashboard, Cursos y Acerca de en 1, todo lo demás en 0
        $permisos = [
            'dashboard' => 1,
            'remisiones' => 0,
            'usuarios' => 0,
            'cursos' => 1,
            'asistencia' => 0,
            'profesionales' => 0,
            'recursos' => 0,
            'ajustes' => 0,
            'acerca' => 1,
            'reportes' => 0
        ];
        
        foreach($permisos as $column => $value) {
            if(in_array($column, $columns)) {
                $updateParts[] = "$column = ?";
                $updateParams[] = $value;
            }
        }
        
        $updateParams[] = $user['id'];
        
        $sql = "UPDATE menu_permissions SET " . implode(', ', $updateParts) . " WHERE user_id = ?";
        $updateStmt = $connect->prepare($sql);
        $updateStmt->execute($updateParams);
        
        echo "<p style='color: green;'>✅ Permisos actualizados correctamente</p>";
        
    } else {
        echo "<h2>No tiene registro. Creando...</h2>";
        
        // Obtener columnas existentes
        $columns = $connect->query("SHOW COLUMNS FROM menu_permissions")->fetchAll(PDO::FETCH_COLUMN);
        
        $insertColumns = ['user_id'];
        $insertValues = ['?'];
        $insertParams = [$user['id']];
        
        $permisos = [
            'dashboard' => 1,
            'remisiones' => 0,
            'usuarios' => 0,
            'cursos' => 1,
            'asistencia' => 0,
            'profesionales' => 0,
            'recursos' => 0,
            'ajustes' => 0,
            'acerca' => 1,
            'reportes' => 0
        ];
        
        foreach($permisos as $column => $value) {
            if(in_array($column, $columns)) {
                $insertColumns[] = $column;
                $insertValues[] = '?';
                $insertParams[] = $value;
            }
        }
        
        $sql = "INSERT INTO menu_permissions (" . implode(', ', $insertColumns) . ") VALUES (" . implode(', ', $insertValues) . ")";
        $insertStmt = $connect->prepare($sql);
        $insertStmt->execute($insertParams);
        
        echo "<p style='color: green;'>✅ Permisos creados correctamente</p>";
    }
    
    // 4. Verificar resultado final
    echo "<h2>Permisos Finales:</h2>";
    $finalStmt = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
    $finalStmt->execute([$user['id']]);
    $final = $finalStmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Módulo</th><th>Valor</th><th>Estado</th></tr>";
    foreach($final as $key => $value) {
        if($key != 'id' && $key != 'user_id') {
            $estado = $value == 1 ? '✅ Habilitado' : '❌ Deshabilitado';
            $color = $value == 1 ? 'lightgreen' : 'lightcoral';
            echo "<tr style='background: $color;'>";
            echo "<td><strong>$key</strong></td>";
            echo "<td>$value</td>";
            echo "<td>$estado</td>";
            echo "</tr>";
        }
    }
    echo "</table>";
    
    echo "<hr>";
    echo "<h2 style='color: green;'>✅ LISTO!</h2>";
    echo "<p><strong>Ahora:</strong></p>";
    echo "<ol>";
    echo "<li>Cierra sesión del admin</li>";
    echo "<li>Login con: <strong>racosta</strong></li>";
    echo "<li>Debe ver SOLO: Dashboard, Cursos, Acerca de</li>";
    echo "</ol>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>
