<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
        header('location: ../login.php');
        exit;
    }
    
    require_once('../../backend/bd/Conexion.php');
    global $connect;
    
    $username = $_SESSION['username'];
    $name = $_SESSION['name'];
    $cedula = $_SESSION['email']; // La cédula está guardada en el campo email
    
    // Verificar si ya completó la inscripción
    try {
        $stmt = $connect->prepare("SELECT * FROM patients WHERE numhs = :cedula");
        $stmt->execute([':cedula' => $cedula]);
        $datos_paciente = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($datos_paciente) {
            // Ya completó la inscripción, redirigir al dashboard
            header('location: dashboard.php');
            exit;
        }
    } catch(PDOException $e) {
        // Error al consultar
    }
    
    // Separar nombre y apellido
    $nombre_completo = explode(' ', $name, 2);
    $nombres = $nombre_completo[0] ?? '';
    $apellidos = $nombre_completo[1] ?? '';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">
    <title>Inscripción - Programa Persona Mayor</title>
    
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
        }
        .containerss {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        .btn-back {
            display: inline-block;
            padding: 12px 25px;
            background: #667eea;
            color: white;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            margin-bottom: 20px;
        }
        .btn-back:hover {
            background: #764ba2;
        }
    </style>
</head>
<body>
    <div class="containerss">
        <a href="dashboard.php" class="btn-back">
            <i class='bx bx-arrow-back'></i> Volver al Dashboard
        </a>
        
        <?php include_once '../../backend/php/inscripcion_ciudadano.php'; ?>
        
        <form action="" enctype="multipart/form-data" method="POST"  autocomplete="off" onsubmit="return validacion()">
  <div class="containerss">
    <h1>Formulario de Inscripción al Programa</h1>
    <div class="alert-danger">
  <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
  <strong>Importante!</strong> Es importante rellenar los campos con &nbsp;<span class="badge-warning">*</span>
</div>
    
    <!-- Barra de Progreso -->
    <div class="progress-container">
        <div class="progress-header">
            <span class="progress-title">Progreso del Formulario</span>
            <span class="progress-percentage" id="progressPercentage">0%</span>
        </div>
        <div class="progress-bar-bg">
            <div class="progress-bar-fill" id="progressBarFill"></div>
        </div>
        <div class="progress-info">
            <span id="fieldsCompleted">0</span> de <span id="totalFields">0</span> campos completados
        </div>
    </div>
    
    <hr>
   
    <label for="psw"><b>modalidad</b></label><span class="badge-warning">*</span>
    <select required name="modalidad" id="modalidad">
        <option>Seleccione</option>
        <option value="Centro día La paz ">Centro día La paz </option>
        <option value="Centro día Bradamonte ">Centro día Bradamonte </option>
        <option value="Centro día Neruda G1">Centro día Neruda G1 </option>
        <option value="Centro día Neruda G2">Centro día Neruda G2 </option>
        <option value="Satélite san Miguel">Satélite san Miguel </option>
        <option value="Satélite perico">Satélite perico</option>
        <option value="Club Santa Isabel ">Club Santa Isabel</option>
        <option value="Club Renacer">Club Renacer </option>
        <option value="Club San José ">Club San José  </option>
        <option value="Club San Benito">Club San Benito  </option>
        <option value="Club San Rafael">Club San Rafael  </option>
        <option value="RAD"> RAD </option>
    </select>
   


    <label for="psw"><b>Tipo de Usuario</b></label><span class="badge-warning">*</span>
    <select required name="tusuario" id="tusuario">
        <option>Seleccione</option>
        <option value="Antiguo">Antiguo</option>
        <option value="Nuevo">Nuevo</option>
        
    </select>  

    <label for="psw"><b>Nombres del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" value="<?php echo $nombres; ?>" placeholder="ejm: Juan Raul" name="namp" required>

    <label for="psw"><b>Apellido del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" value="<?php echo $apellidos; ?>" placeholder="ejm: Ramirez Requena" name="apep" required>

    <label for="psw"><b>Tipó de Documento</b></label><span class="badge-warning">*</span>
    <select required name="tdocumento" id="tdocumento">
        <option>Seleccione</option>
        <option value="C.C">C.C</option>
        <option value="C.E">C.E</option>
        <option value="SIN ID">SIN ID</option>
    </select>  

    <label for="email"><b>Documento de identidad</b></label><span class="badge-warning">*</span>
    <input type="text" value="<?php echo $cedula; ?>" placeholder="ejm: 77114578" name="nhi" maxlength="10" required disabled>
    <input type="hidden" name="nhi" value="<?php echo $cedula; ?>">
    
    <label for="psw"><b>Fecha de Expedición</b></label><span class="badge-warning">*</span>
    <input type="date" name="fexpedicion" required>

    <label for="psw"><b>Lugar Expedición</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Bogota" name="lexpedicion" required>

    <label for="psw"><b>Fecha de nacimiento del usuario</b></label><span class="badge-warning">*</span>
    <input type="date" name="cump" required>

    <label for="fotoperfil"><b>Foto de Perfil</b></label><span class="badge-warning">*</span>
    <input type="file" name="fotoperfil" id="fotoperfil" accept="image/*">
    <div id="preview-foto" style="margin-top: 10px;">
        <img id="img-preview" src="" alt="Vista previa" style="max-width: 200px; max-height: 200px; display: none; border: 2px solid #27ae60; border-radius: 8px;">
    </div>


    <label for="psw"><b>Grupo sanguíneo del usuario</b></label><span class="badge-warning">*</span>
    <select required name="grp" id="grp">
        <option>Seleccione</option>
        <option value="A+">A+</option>
        <option value="A-">A-</option>
        <option value="O+">O+</option>
        <option value="O-">O-</option>
        <option value="B+">B+</option>
        <option value="B-">B-</option>
        <option value="AB+">AB-</option>
        <option value="AB-">AB-</option>

    </select>
   
    <label for="psw"><b>Estado Civil</b></label><span class="badge-warning">*</span>
    <select required name="ecivil" id="ecivil">
        <option>Seleccione</option>
        <option value="casado">Casado</option>
        <option value="soltero">Soltero</option>
        <option value="Viudos">Viudos</option>
        <option value="Union Libre">Union Libre</option>
    </select>

    <label for="psw"><b>Género del usuario</b></label><span class="badge-warning">*</span>
    <select required name="gep" id="gep">
        <option>Seleccione</option>
        <option value="Masculino">Masculino</option>
        <option value="Femenino">Femenino</option>
        <option value="Bisexual">Bisexual</option>
        <option value="Intersexual">Intersexual</option>
    </select>

    <hr>

    <label for="psw"><b>ZONA</b></label><span class="badge-warning">*</span>
    <select required name="zona" id="zona">
        <option>Seleccione</option>
        <option value="Urbana">Urbana</option>
        <option value="Rural">Rural</option>
        <option value="Centro Poblado">Centro Poblado</option>
    </select>  

    <label for="psw"><b>BARRIO</b></label><span class="badge-warning">*</span>
    <select required name="barrio" id="barrio">
        <option>Seleccione</option>
                <option value="la paz">La Paz</option>
                <option value="san jorge">San Jorge</option>
                <option value="san josé">San José</option>
                <option value="santa teresa">Santa Teresa</option>
                <option value="san rafael">San Rafael</option>
                <option value="el carmen">El Carmen</option>
                <option value="san martín">San Martín</option>
                <option value="villas de santa ana">Villas de Santa Ana</option>
                <option value="san juan">San Juan</option>
                <option value="santa isabel">Santa Isabel</option>
                <option value="el progreso">El Progreso</option>
                <option value="la inmaculada">La Inmaculada</option>
                <option value="balcones de san josé">Balcones de San José</option>
                <option value="el mirador">El Mirador</option>
                <option value="la reserva">La Reserva</option>
                <option value="parques del muña">Parques del Muña</option>
                <option value="garcía">García</option>
                <option value="pablo neruda">Pablo Neruda</option>
                <option value="alto charco">Alto Charco</option>
                <option value="bradamonte">Bradamonte</option>
                <option value="chacua">Chacua</option>
                <option value="las delicias">Las Delicias</option>
                <option value="el peñón">El Peñón</option>
                <option value="la unión">La Unión</option>
                <option value="el perico">El Perico</option>
                <option value="romeral">Romeral</option>
                <option value="san benito">San Benito</option>
                <option value="san eugenio">San Eugenio</option>
                <option value="san fortunato">San Fortunato</option>
                <option value="san miguel">San Miguel</option>
                <option value="san rafael rural">San Rafael Rural</option>
                <option value="usaba">Usaba</option>

    </select>  

   <label for="psw"><b>Dirección del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: calle los medanos" name="dip" required>

    <label for="psw"><b>Teléfono del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" maxlength="13" placeholder="ejm: +51 999 888 111" name="telp" required>

    <label for="psw"><b>¿El usuario tiene WhatsApp?</b></label><span class="badge-warning">*</span>
    <select required name="tiene_whatsapp" id="tiene_whatsapp">
        <option value="">Seleccione</option>
        <option value="SI">Sí</option>
        <option value="NO">No</option>
    </select>

    <label for="email"><b>correo</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="correo" name="correo" maxlength="70" required>
    
    <hr>

    <label for="psw"><b>sisben</b></label><span class="badge-warning">*</span>
    <select required name="sisben" id="sisben">
        <option>Seleccione</option>
        <option value="A1">A1</option>
        <option value="A2">A2</option>
        <option value="A3">A3</option>
        <option value="A4">A4</option>
        <option value="A5">A5</option>
        <option value="B1">B1</option>
        <option value="B2">B2</option>
        <option value="B3">B3</option>
        <option value="B4">B4</option>
        <option value="B5">B5</option>
        <option value="B6">B6</option>
        <option value="B7">B7</option>
        <option value="C1">C1</option>
        <option value="C2">C2</option>
        <option value="C3">C3</option>
        <option value="C4">C4</option>
        <option value="C5">C5</option>
        <option value="C6">C6</option>
        <option value="C7">C7</option>
        <option value="C8">C8</option>
        <option value="C9">C9</option>
        <option value="10">10</option>
        <option value="C11">C11</option>
        <option value="C12">C12</option>
        <option value="C13">C13</option>
        <option value="C14">C14</option>
        <option value="C15">C15</option>
        <option value="C16">C16</option>
        <option value="C17">C17</option>
        <option value="C18">C18</option>
        <option value="D1">D1</option>
        <option value="D2">D2</option>
        <option value="D3">D3</option>
        <option value="D4">D4</option>
        <option value="D5">D5</option>
        <option value="D6">D6</option>
        <option value="D7">D7</option>
        <option value="D8">D8</option>
        <option value="D9">D9</option>
        <option value="D10">D10</option>
        <option value="D11">D11</option>
        <option value="D12">D12</option>
        <option value="D13">D13</option>
        <option value="D14">D14</option>
        <option value="D15">D15</option>
        <option value="D16">D16</option>
        <option value="D17">D17</option>
        <option value="D18">D18</option>
        <option value="D19">D19</option>
        <option value="D20">D20</option>
        <option value="D21">D21</option>
    </select>  

    <label for="psw"><b>Recibe Bono</b></label><span class="badge-warning">*</span>
    <select required name="rbono" id="rbono">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    
    <label for="psw"><b>pensionado</b></label><span class="badge-warning">*</span>
    <select required name="pensionado" id="pensionado">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>Talla sudadera</b></label><span class="badge-warning">*</span>
    <select required name="tsudadera" id="tsudadera">
        <option>Seleccione</option>
        <option value="S">S</option>
        <option value="M">M</option>        
        <option value="L">L</option>        
        <option value="x">X</option>        
        <option value="xS">XS</option>        
        <option value="xL">XL</option>        
    </select>


    <label for="psw"><b>Talla chaqueta</b></label><span class="badge-warning">*</span>
    <select required name="tchaqueta" id="tchaqueta">
        <option>Seleccione</option>
        <option value="S">S</option>
        <option value="M">M</option>        
        <option value="L">L</option>        
        <option value="x">X</option>        
        <option value="xS">XS</option>        
        <option value="xL">XL</option>        
    </select>


    <label for="email"><b>Talla zapatos</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="tzapatos" name="tzapatos" maxlength="8" required>

    

    
   
    <hr>

    <label for="email"><b>¿ CUAL CONSIDERA USTED QUE ES SU MAYOR FORTALEZA O TALENTO ?</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="talentof" name="talentof" maxlength="30" required>

    <label for="psw"><b>EL ADULTO MAYOR INGRESA Y SE VA SOLO DE PROGRAMA</b></label><span class="badge-warning">*</span>
    <select required name="rbono" id="rbono">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

   
    <label for="email"><b>¿Con quien Vive?</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="vivecomp" name="vivecomp" maxlength="30" required>
   

    <label for="psw"><b>¿La persona Mayor considera que posee red de apoyo?</b></label><span class="badge-warning">*</span>
    <select required name="redapoyo" id="redapoyo">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <hr>

    <label for="email"><b>Nombre  y apellido del Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="cuidador" name="cuidador" maxlength="30" required>
    <hr>

    <label for="psw"><b>Parentesco del Cuidador</b></label><span class="badge-warning">*</span>
    <select required name="pcuidador" id="pcuidador">
        <option>Seleccione</option>
        <option value="CÓNYUGE y/o COMPAÑERO">ACÓNYUGE y/o COMPAÑERO</option>
        <option value="Hijo">Hijo</option>
        <option value="Familia">Familia</option>
        <option value="Vecinoamigo">Vecino o Amigo</option>
        <option value="Institucional">Institucional</option>
    </select>

    <label for="psw"><b>Zona Cuidador</b></label><span class="badge-warning">*</span>
    <select required name="zcuidador" id="zcuidador">
        <option>Seleccione</option>
        <option value="Urbano">Urbano</option>
        <option value="Rural">Rural</option>
        <option value="CentroP">Centro Poblado</option>
    </select>

    <label for="psw"><b>Barrio, Vereda, Centro Poblado del cuidador</b></label><span class="badge-warning">*</span>
    <select required name="bvccuidador" id="bvccuidador">
        <option>Seleccione</option>
         <option value="la paz">La Paz</option>
                <option value="san jorge">San Jorge</option>
                <option value="san josé">San José</option>
                <option value="santa teresa">Santa Teresa</option>
                <option value="san rafael">San Rafael</option>
                <option value="el carmen">El Carmen</option>
                <option value="san martín">San Martín</option>
                <option value="villas de santa ana">Villas de Santa Ana</option>
                <option value="san juan">San Juan</option>
                <option value="santa isabel">Santa Isabel</option>
                <option value="el progreso">El Progreso</option>
                <option value="la inmaculada">La Inmaculada</option>
                <option value="balcones de san josé">Balcones de San José</option>
                <option value="el mirador">El Mirador</option>
                <option value="la reserva">La Reserva</option>
                <option value="parques del muña">Parques del Muña</option>
                <option value="garcía">García</option>
                <option value="pablo neruda">Pablo Neruda</option>
                <option value="alto charco">Alto Charco</option>
                <option value="bradamonte">Bradamonte</option>
                <option value="chacua">Chacua</option>
                <option value="las delicias">Las Delicias</option>
                <option value="el peñón">El Peñón</option>
                <option value="la unión">La Unión</option>
                <option value="el perico">El Perico</option>
                <option value="romeral">Romeral</option>
                <option value="san benito">San Benito</option>
                <option value="san eugenio">San Eugenio</option>
                <option value="san fortunato">San Fortunato</option>
                <option value="san miguel">San Miguel</option>
                <option value="san rafael rural">San Rafael Rural</option>
                <option value="usaba">Usaba</option>
    </select>

    <label for="email"><b>Direccion del Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="dcuidador" name="dcuidador" maxlength="30" required>
    
    <label for="email"><b>Telefono Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="tcuidador" name="tcuidador" maxlength="30" required>
    <hr>

    <label for="psw"><b>Que SGSSS</b></label><span class="badge-warning">*</span>
    <select required name="sgsss" id="sgsss">
        <option>Seleccione</option>
        <option value="Contributivo">Contributivo</option>
        <option value="Subsidiado">Subsidiado</option>
        <option value="Regimen Especial">Regimen Especial</option>
        <option value="No Asegurado">No Asegurado</option>
    </select>

    <label for="psw"><b>Que EPS</b></label><span class="badge-warning">*</span>
    <select required name="eps" id="eps">
        <option>Seleccione</option>
        <option value="SANITAS">SANITAS</option>
        <option value="SALUD TOTAL">SALUD TOTAL</option>
        <option value="Compensar">Compensar</option>
        <option value="Cruz verde">Cruz verde</option>
        <option value="Nueva EPS">Nueva EPS</option>
        <option value="Coosalud EPS-S">Coosalud EPS-S</option>
        <option value="Mutual SER">Mutual SER</option>
        <option value="Salud MIA">Salud MIA</option>
        <option value="Aliansalud EPS">Aliansalud EPS</option>
        <option value="Salud Total EPS S.A.">Salud Total EPS S.A.</option>
        <option value="EPS Sanitas">EPS Sanitas</option>
        <option value="EPS Sura">EPS Sura</option>
        <option value="Famisanar EPS">Famisanar EPS</option>
        <option value="Servicio Occidental de Salud EPS – SOS">Servicio Occidental de Salud EPS – SOS</option>
        <option value="Comfenalco Valle">Comfenalco Valle</option>
        <option value="Compensar EPS">Compensar EPS</option>
        <option value="Empresas Públicas de Medellín EPM">Empresas Públicas de Medellín EPM</option>
        <option value="Fondo de Pasivo Social de Ferrocarriles Nacionales de Colombia">Fondo de Pasivo Social de Ferrocarriles Nacionales de Colombia</option>
        <option value="Cajacopi Atlántico">Cajacopi Atlántico</option>
        <option value="Capresoca EPS">Capresoca EPS</option>
        <option value="Comfachocó">Comfachocó</option>
        <option value="Comfaoriente">Comfaoriente</option>
        <option value="EPS Familiar de Colombia">EPS Familiar de Colombia</option>
        <option value="Asmet Salud EPS">Asmet Salud EPS</option>
        <option value="Emssanar E.S.S.">Emssanar E.S.S.</option>
        <option value="Capital Salud EPS-S">Capital Salud EPS-S</option>
        <option value="Savia Salud EPS">Savia Salud EPS</option>
        <option value="Dusakawi EPSI">Dusakawi EPSI</option>
        <option value="Asociación Indígena del Cauca EPSI">Asociación Indígena del Cauca EPSI</option>
        <option value="Anas Wayuu EPSI">Anas Wayuu EPSI</option>
        <option value="Mallamas EPSI">Mallamas EPSI</option>
        <option value="Pijaos Salud EPSI">Pijaos Salud EPSI</option>
    </select>

    <label for="psw"><b>Que ETNIA</b></label><span class="badge-warning">*</span>
    <select required name="etnia" id="etnia">
        <option>Seleccione</option>
        <option value="INDIGENA">INDIGENA</option>
        <option value="AFROCOLOMBIANO">AFRO COLOMBIANO</option>
        <option value="ROM-GITANO">ROM-GITANO</option>
        <option value="PALENQUERO">PALENQUERO</option>
        <option value="RAIZAL">RAIZAL</option>
        <option value="NINGUNO">NINGUNO</option>
    </select>

    <label for="psw"><b>Nivel Maximo Alcanzado</b></label><span class="badge-warning">*</span>
    <select required name="educacion" id="educacion">
        <option>Seleccione</option>
        <option value="PRIMARIA">PRIMARIA</option>
        <option value="SECUNDARIA">SECUNDARIA</option>
        <option value="TECNICA">TECNICA</option>
        <option value="SUPERIOR">SUPERIOR </option>
        <option value="NINGUNO">NINGUNO </option>
    </select>

    <label for="psw"><b>Sabe leer y escribir</b></label><span class="badge-warning">*</span>
    <select required name="leer" id="leer">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>¿Hace uso de las tecnologias?</b></label><span class="badge-warning">*</span>
    <select required name="utecnologia" id="utecnologia">
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>¿Hace parte de una poblaciòn diferencial o de inclusion?</b></label><span class="badge-warning">*</span>
    <select required name="poblaciond" id="poblaciond">
        <option>Seleccione</option>
        <option value="discapacidad">discapacidad</option>
        <option value="situacion_especial">en situaciòn de proteccion especial</option>        
        <option value="desplazada">poblacion desplazada</option>
        <option value="vulnerable">En SItuaciòn de Vulneración</option>
        <option value="cuidado_terceros">Persona que se encuentra al cuidado de tercero</option>
        <option value="abandono">Situaciòn de abandono</option>
        <option value="habitante calle">Habitante de calle</option>
        <option value="victima">Victima del conflicto armado</option>
        <option value="Reinsertado">Reinsertado</option>
        <option value="ninguno">ninguno</option>
    </select>

    <label for="psw"><b>¿Hace parte de poblacion diferencial por oficio?</b></label><span class="badge-warning">*</span>
    <select required name="poblacionoficio" id="poblacionoficio">
        <option>Seleccione</option>
        <option value="Reciclador">Reciclador</option>
        <option value="Bodegueros">Pequños Bodegueros</option>        
        <option value="vendedor">Vendedor Ambulante</option>
        <option value="ninguno">ninguno</option>
    </select>

    <hr>

    
    <!-- Sección QR -->
<label for="qrInput"><b>Genera tu Carnet</b></label><span class="badge-warning">*</span>
<div style="display: flex; align-items: center;">
    <input type="text" placeholder="qrInput" name="qrInput" id="qrInput" maxlength="8" required readonly>
    <button type="button" onclick="generateQR()" style="margin-left: 10px; padding: 5px 10px;">Generar QR</button>
</div>
<div id="qrCode" style="margin-top: 10px; text-align: center; font-family: Arial, sans-serif;"></div>

<!-- Botón de descarga (oculto inicialmente) -->
<button type="button" id="downloadQRBtn" style="display: none; margin: 10px 0; padding: 8px 15px; background: #27ae60; color: white; border: none; border-radius: 4px; cursor: pointer;">
    <i class='bx bx-download'></i> Descargar QR
</button>

<button type="submit" name="inscripcion_ciudadano" class="registerbtn">Guardar</button>
</form>
    </div>
    
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    
    <!-- Script para previsualizar la imagen -->
    <script>
    document.getElementById('fotoperfil').addEventListener('change', function(e) {
        const file = e.target.files[0];
        const preview = document.getElementById('img-preview');
        
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.style.display = 'block';
            }
            reader.readAsDataURL(file);
        } else {
            preview.style.display = 'none';
        }
    });
    </script>
</body>
</html>