<?php
    ob_start();
    session_start();
    
    if(!isset($_SESSION['user_type']) || $_SESSION['user_type'] != 'ciudadano'){
        header('location: ../login.php');
        exit;
    }
    
    require_once('../../backend/bd/Conexion.php');
    global $connect;
    
    $username = $_SESSION['username'];
    $name = $_SESSION['name'];
    $cedula = $_SESSION['email'];
    
    // Obtener cursos disponibles
    $cursos_disponibles = [];
    try {
        $stmt = $connect->prepare("SELECT * FROM cursos ORDER BY nombre ASC");
        $stmt->execute();
        $cursos_disponibles = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        $error = "Error al cargar cursos: " . $e->getMessage();
    }
    
    // Obtener cursos en los que está inscrito
    $mis_inscripciones = [];
    try {
        $stmt = $connect->prepare("
            SELECT c.*, i.documento 
            FROM inscripciones i 
            INNER JOIN cursos c ON i.idcurso = c.idcurso 
            WHERE i.documento = :cedula
        ");
        $stmt->execute([':cedula' => $cedula]);
        $mis_inscripciones = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch(PDOException $e) {
        $error = "Error al cargar inscripciones: " . $e->getMessage();
    }
    
    // Crear array de IDs de cursos inscritos para verificación rápida
    $cursos_inscritos_ids = array_column($mis_inscripciones, 'idcurso');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Mis Cursos - Programa Persona Mayor</title>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header h1 {
            font-size: 28px;
            color: #667eea;
            margin: 0;
        }

        .btn-back {
            padding: 10px 20px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-back:hover {
            background: #764ba2;
        }

        .section {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }

        .section h2 {
            font-size: 24px;
            color: #667eea;
            margin-bottom: 20px;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }

        .cursos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }

        .curso-card {
            background: white;
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            padding: 20px;
            transition: all 0.3s ease;
        }

        .curso-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
            border-color: #667eea;
        }

        .curso-card h3 {
            font-size: 20px;
            color: #333;
            margin-bottom: 10px;
        }

        .curso-info {
            margin: 15px 0;
        }

        .curso-info-item {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
            font-size: 14px;
            color: #666;
        }

        .curso-info-item i {
            margin-right: 8px;
            color: #667eea;
        }

        .btn-inscribir {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-inscribir:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-inscrito {
            width: 100%;
            padding: 12px;
            background: #27ae60;
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: not-allowed;
        }

        .badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
            margin-left: 10px;
        }

        .badge-titulado {
            background: #d4edda;
            color: #155724;
        }

        .badge-no-titulado {
            background: #fff3cd;
            color: #856404;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 600;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 5px solid #28a745;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border-left: 5px solid #dc3545;
        }

        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border-left: 5px solid #17a2b8;
        }

        .empty-state {
            text-align: center;
            padding: 40px;
            color: #999;
        }

        .empty-state i {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.3;
        }

        @media (max-width: 768px) {
            .cursos-grid {
                grid-template-columns: 1fr;
            }

            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class='bx bxs-book-alt'></i> Mis Cursos</h1>
            <a href="dashboard.php" class="btn-back">
                <i class='bx bx-arrow-back'></i> Volver al Dashboard
            </a>
        </div>

        <?php include_once '../../backend/php/inscribir_curso_ciudadano.php'; ?>

        <!-- Cursos en los que estoy inscrito -->
        <div class="section">
            <h2><i class='bx bxs-check-circle'></i> Mis Inscripciones</h2>
            
            <?php if(count($mis_inscripciones) > 0): ?>
                <div class="cursos-grid">
                    <?php foreach($mis_inscripciones as $curso): ?>
                        <div class="curso-card">
                            <h3>
                                <?php echo htmlspecialchars($curso['nombre']); ?>
                                <?php if($curso['es_titulado'] == 'sí'): ?>
                                    <span class="badge badge-titulado">Titulado</span>
                                <?php else: ?>
                                    <span class="badge badge-no-titulado">No Titulado</span>
                                <?php endif; ?>
                            </h3>
                            
                            <div class="curso-info">
                                <div class="curso-info-item">
                                    <i class='bx bxs-user'></i>
                                    <span><strong>Profesor:</strong> <?php echo htmlspecialchars($curso['quien_lo_da']); ?></span>
                                </div>
                                
                                <?php if(!empty($curso['en_que'])): ?>
                                <div class="curso-info-item">
                                    <i class='bx bxs-info-circle'></i>
                                    <span><?php echo htmlspecialchars($curso['en_que']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <button class="btn-inscrito" disabled>
                                <i class='bx bx-check'></i> Ya inscrito
                            </button>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class='bx bx-book-open'></i>
                    <p>Aún no estás inscrito en ningún curso.</p>
                    <p>Explora los cursos disponibles abajo y comienza tu aprendizaje.</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Cursos disponibles -->
        <div class="section">
            <h2><i class='bx bxs-graduation'></i> Cursos Disponibles</h2>
            
            <?php if(count($cursos_disponibles) > 0): ?>
                <div class="cursos-grid">
                    <?php foreach($cursos_disponibles as $curso): ?>
                        <?php if(!in_array($curso['idcurso'], $cursos_inscritos_ids)): ?>
                        <div class="curso-card">
                            <h3>
                                <?php echo htmlspecialchars($curso['nombre']); ?>
                                <?php if($curso['es_titulado'] == 'sí'): ?>
                                    <span class="badge badge-titulado">Titulado</span>
                                <?php else: ?>
                                    <span class="badge badge-no-titulado">No Titulado</span>
                                <?php endif; ?>
                            </h3>
                            
                            <div class="curso-info">
                                <div class="curso-info-item">
                                    <i class='bx bxs-user'></i>
                                    <span><strong>Profesor:</strong> <?php echo htmlspecialchars($curso['quien_lo_da']); ?></span>
                                </div>
                                
                                <?php if(!empty($curso['en_que'])): ?>
                                <div class="curso-info-item">
                                    <i class='bx bxs-info-circle'></i>
                                    <span><?php echo htmlspecialchars($curso['en_que']); ?></span>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <form method="POST" style="margin: 0;">
                                <input type="hidden" name="idcurso" value="<?php echo $curso['idcurso']; ?>">
                                <button type="submit" name="inscribir_curso" class="btn-inscribir">
                                    <i class='bx bx-plus-circle'></i> Inscribirme
                                </button>
                            </form>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class='bx bx-book'></i>
                    <p>No hay cursos disponibles en este momento.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="../../backend/js/jquery.min.js"></script>
</body>
</html>
