<?php 
session_start();
include_once '../backend/php/login.php'
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <title>PROGRAMA MUNICIPAL | PERSONA MAYOR</title>
  <link rel="stylesheet" href="../backend/css/style.css" />
  <link rel="icon" type="image/png" sizes="96x96" href="../backend/img/ico.svg" />

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
      position: relative;
      overflow: hidden;
    }

    body::before {
      content: '';
      position: absolute;
      width: 100%;
      height: 100%;
      background: url('../backend/img/fondologin2.jpeg') no-repeat center center;
      background-size: cover;
      opacity: 0.4;
      z-index: 0;
    }

    .form-container {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      max-width: 480px;
      width: 100%;
      padding: 55px 50px;
      border-radius: 24px;
      box-shadow: 0 30px 80px rgba(102, 126, 234, 0.3), 0 15px 35px rgba(118, 75, 162, 0.2);
      position: relative;
      z-index: 1;
      animation: slideIn 0.6s cubic-bezier(0.16, 1, 0.3, 1);
      border: 1px solid rgba(255, 255, 255, 0.6);
    }

    @keyframes slideIn {
      from {
        opacity: 0;
        transform: translateY(-30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .heading {
      text-align: center;
      font-size: 26px;
      font-weight: 700;
      margin-bottom: 8px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      line-height: 1.3;
      letter-spacing: -0.5px;
    }

    .subtitle {
      text-align: center;
      font-size: 14px;
      color: #777;
      margin-bottom: 40px;
      font-weight: 400;
      letter-spacing: 0.2px;
    }

    .input-group {
      position: relative;
      margin-bottom: 22px;
    }

    .input-label {
      display: block;
      font-size: 13px;
      font-weight: 600;
      color: #333;
      margin-bottom: 8px;
      letter-spacing: 0.3px;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #764ba2;
      font-size: 18px;
      pointer-events: none;
      transition: all 0.3s ease;
    }

    .form-input {
      width: 100%;
      padding: 16px 15px 16px 48px;
      border: 2px solid #e8e8e8;
      border-radius: 14px;
      font-size: 15px;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      background: #f8f9fc;
      color: #1a1a1a;
      font-weight: 500;
    }

    .form-input:focus {
      outline: none;
      border-color: #667eea;
      background: #fff;
      box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.15), 0 4px 12px rgba(118, 75, 162, 0.1);
      transform: translateY(-1px);
    }

    .form-input:focus + .input-icon {
      color: #667eea;
    }

    .form-input::placeholder {
      color: #999;
    }

    .btn.submit-btn {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      padding: 17px;
      width: 100%;
      font-size: 15px;
      font-weight: 700;
      border-radius: 14px;
      cursor: pointer;
      margin-top: 18px;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.45), 0 2px 8px rgba(118, 75, 162, 0.25);
      text-transform: uppercase;
      letter-spacing: 1px;
      position: relative;
      overflow: hidden;
    }

    .btn.submit-btn::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
      transition: left 0.5s ease;
    }

    .btn.submit-btn:hover::before {
      left: 100%;
    }

    .btn.submit-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 30px rgba(102, 126, 234, 0.6), 0 4px 12px rgba(118, 75, 162, 0.4);
    }

    .btn.submit-btn:active {
      transform: translateY(0);
    }

    .btm-line {
      text-align: center;
      margin-top: 30px;
      font-size: 12px;
      color: #888;
      line-height: 1.6;
    }

    .span-2 {
      width: 100%;
    }

    .error-msg {
      background: linear-gradient(135deg, #fee 0%, #fdd 100%);
      color: #c33;
      text-align: center;
      font-size: 14px;
      font-weight: 600;
      padding: 14px 18px;
      border-radius: 12px;
      margin-bottom: 25px;
      border-left: 5px solid #c33;
      animation: shake 0.5s ease;
      box-shadow: 0 4px 12px rgba(204, 51, 51, 0.15);
    }

    @keyframes shake {
      0%, 100% { transform: translateX(0); }
      25% { transform: translateX(-10px); }
      75% { transform: translateX(10px); }
    }

    .logo-container {
      text-align: center;
      margin-bottom: 25px;
    }

    .logo-circle {
      width: 110px;
      height: 110px;
      margin: 0 auto;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 15px 40px rgba(102, 126, 234, 0.5), 0 5px 15px rgba(118, 75, 162, 0.3);
      position: relative;
      transition: transform 0.3s ease;
    }

    .logo-circle::after {
      content: '';
      position: absolute;
      width: 100%;
      height: 100%;
      border-radius: 50%;
      border: 3px solid rgba(118, 75, 162, 0.3);
      top: -10px;
      left: -10px;
      right: -10px;
      bottom: -10px;
    }

    .logo-circle svg {
      width: 55px;
      height: 55px;
      fill: white;
    }

    .brand-name {
      text-align: center;
      margin-top: 18px;
      margin-bottom: 25px;
    }

    .brand-name h2 {
      font-size: 32px;
      font-weight: 800;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      margin: 0;
      letter-spacing: 1px;
      text-transform: uppercase;
    }

    .brand-tagline {
      font-size: 12px;
      color: #764ba2;
      margin-top: 5px;
      letter-spacing: 2px;
      text-transform: uppercase;
      font-weight: 600;
    }

    .welcome-screen {
      display: block;
      text-align: center;
    }

    .welcome-screen.hidden {
      display: none;
    }

    .user-type-selection {
      display: none;
      text-align: center;
    }

    .user-type-selection.active {
      display: block;
    }

    .login-form-section {
      display: none;
    }

    .login-form-section.active {
      display: block;
    }

    .user-type-buttons {
      display: flex;
      gap: 20px;
      margin-top: 30px;
      flex-wrap: wrap;
      justify-content: center;
    }

    .btn-user-type {
      flex: 1;
      min-width: 180px;
      padding: 25px 30px;
      background: white;
      border: 3px solid #667eea;
      border-radius: 16px;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .btn-user-type:hover {
      transform: translateY(-5px);
      box-shadow: 0 15px 40px rgba(102, 126, 234, 0.4);
      border-color: #764ba2;
    }

    .btn-user-type svg {
      width: 60px;
      height: 60px;
      margin-bottom: 15px;
    }

    .btn-user-type h3 {
      font-size: 20px;
      color: #667eea;
      margin: 10px 0 5px 0;
      font-weight: 700;
    }

    .btn-user-type p {
      font-size: 13px;
      color: #666;
      margin: 0;
    }

    .btn-back {
      margin-top: 20px;
      padding: 12px 25px;
      background: transparent;
      border: 2px solid #ddd;
      color: #666;
      border-radius: 10px;
      cursor: pointer;
      font-size: 14px;
      font-weight: 600;
      transition: all 0.3s ease;
    }

    .btn-back:hover {
      border-color: #667eea;
      color: #667eea;
      transform: translateX(-5px);
    }

    .welcome-title {
      font-size: 34px;
      font-weight: 800;
      margin-bottom: 15px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      letter-spacing: -0.5px;
    }

    .welcome-subtitle {
      font-size: 15px;
      color: #555;
      margin-bottom: 45px;
      line-height: 1.7;
      font-weight: 400;
      letter-spacing: 0.3px;
    }

    .btn-show-login {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      padding: 18px 45px;
      font-size: 16px;
      font-weight: 700;
      border-radius: 14px;
      cursor: pointer;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.45), 0 2px 8px rgba(118, 75, 162, 0.25);
      display: inline-flex;
      align-items: center;
      gap: 12px;
      letter-spacing: 0.5px;
      position: relative;
      overflow: hidden;
    }

    .btn-show-login::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
      transition: left 0.5s ease;
    }

    .btn-show-login:hover::before {
      left: 100%;
    }

    .btn-show-login:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 30px rgba(102, 126, 234, 0.6), 0 4px 12px rgba(118, 75, 162, 0.4);
    }

    .btn-show-login svg {
      width: 20px;
      height: 20px;
    }

    @media (max-width: 480px) {
      .form-container {
        padding: 40px 30px;
      }
      
      .heading {
        font-size: 24px;
      }

      .welcome-title {
        font-size: 26px;
      }
    }
  </style>
</head>
<body>
  <div class="form-container">
    <!-- Welcome Screen -->
    <div class="welcome-screen" id="welcomeScreen">
      <div class="logo-container">
        <div class="logo-circle">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white">
            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"/>
            <path d="M15.5 8c0-.28.22-.5.5-.5s.5.22.5.5-.22.5-.5.5-.5-.22-.5-.5zm-7 0c0-.28.22-.5.5-.5s.5.22.5.5-.22.5-.5.5-.5-.22-.5-.5z" opacity="0.7"/>
          </svg>
        </div>
        <div class="brand-name">
          <h2>XIUA ABUELOS</h2>
          <div class="brand-tagline">Cuidado y Gestión</div>
        </div>
      </div>

      <h1 class="welcome-title">
        ¡Bienvenido al Sistema!
      </h1>
      <p class="welcome-subtitle">
        PROGRAMA MUNICIPAL<br/>
        PERSONA MAYOR<br/><br/>
        Ingresa tus credenciales para acceder al sistema
      </p>

      <button class="btn-show-login" onclick="showLoginForm()">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
          <path d="M15 3h4a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2h-4"></path>
          <polyline points="10 17 15 12 10 7"></polyline>
          <line x1="15" y1="12" x2="3" y2="12"></line>
        </svg>
        Iniciar Sesión
      </button>

      <a href="ciudadano/registro.php" style="display: inline-block; margin-top: 20px; padding: 15px 30px; background: white; color: #667eea; border-radius: 12px; text-decoration: none; font-weight: 600; transition: all 0.3s ease; border: 2px solid white; box-shadow: 0 4px 15px rgba(255,255,255,0.3);">
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="vertical-align: middle; margin-right: 8px;">
          <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
          <circle cx="8.5" cy="7" r="4"></circle>
          <line x1="20" y1="8" x2="20" y2="14"></line>
          <line x1="23" y1="11" x2="17" y2="11"></line>
        </svg>
        ¿Primera vez? Regístrate aquí
      </a>
      
      <p style="margin-top: 20px; color: white; font-size: 13px; opacity: 0.8;">
        ¿Eres un adulto mayor? Crea tu cuenta y accede al programa
      </p>
    </div>

    <!-- User Type Selection -->
    <div class="user-type-selection" id="userTypeSelection">
      <div class="logo-container">
        <div class="logo-circle">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white">
            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"/>
          </svg>
        </div>
        <div class="brand-name">
          <h2>XIUA ABUELOS</h2>
          <div class="brand-tagline">Cuidado y Gestión</div>
        </div>
      </div>

      <h1 class="welcome-title">¿Cómo deseas ingresar?</h1>
      <p class="welcome-subtitle">Selecciona el tipo de acceso</p>

      <div class="user-type-buttons">
        <div class="btn-user-type" onclick="showLoginForm('funcionario')">
          <svg fill="#667eea" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
            <path d="M20 8h-2V6h-2v2h-2v2h2v2h2v-2h2z" opacity="0.7"/>
          </svg>
          <h3>Funcionario</h3>
          <p>Acceso al sistema administrativo</p>
        </div>

        <div class="btn-user-type" onclick="showLoginForm('ciudadano')">
          <svg fill="#764ba2" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
          </svg>
          <h3>Ciudadano</h3>
          <p>Portal del adulto mayor</p>
        </div>
      </div>

      <button class="btn-back" onclick="backToWelcome()">← Volver</button>
    </div>

    <!-- Login Form Section -->
    <div class="login-form-section" id="loginFormSection">
      <div class="logo-container">
        <div class="logo-circle">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white">
            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"/>
            <path d="M15.5 8c0-.28.22-.5.5-.5s.5.22.5.5-.22.5-.5.5-.5-.22-.5-.5zm-7 0c0-.28.22-.5.5-.5s.5.22.5.5-.22.5-.5.5-.5-.22-.5-.5z" opacity="0.7"/>
          </svg>
        </div>
        <div class="brand-name">
          <h2>XIUA ABUELOS</h2>
          <div class="brand-tagline">Cuidado y Gestión</div>
        </div>
      </div>

      <h1 class="heading">
        PROGRAMA MUNICIPAL <br />
        PERSONA MAYOR
      </h1>
      <p class="subtitle">Ingresa tu usuario o documento y contraseña</p>

      <?php 
      if (isset($errMsg)) {
          echo '<div class="error-msg">'.$errMsg.'</div>';
      }
      ?>

      <form action="" method="POST" autocomplete="off">
        <div class="input-group">
          <input
            type="text"
            name="username"
            value="<?php if (isset($_POST['username'])) echo $_POST['username']; ?>"
            class="form-input span-2"
            placeholder="Usuario o Documento"
            required
          />
          <span class="input-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
              <circle cx="12" cy="7" r="4"></circle>
            </svg>
          </span>
        </div>

        <div class="input-group">
          <input
            type="password"
            name="password"
            class="form-input span-2"
            placeholder="Contraseña"
            required
          />
          <span class="input-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
              <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
            </svg>
          </span>
        </div>

        <button class="btn submit-btn span-2" name="login" type="submit">Iniciar sesión</button>
      </form>

      <button class="btn-back" onclick="backToWelcome()">← Volver</button>

      <p class="btm-line">
        Derechos reservados, acepta nuestros Términos de servicio y Política de privacidad.
      </p>
    </div>
  </div>

  <script>
    function showLoginForm() {
      document.getElementById('welcomeScreen').classList.add('hidden');
      document.getElementById('loginFormSection').classList.add('active');
    }

    function backToWelcome() {
      document.getElementById('loginFormSection').classList.remove('active');
      document.getElementById('welcomeScreen').classList.remove('hidden');
    }

    // Si hay un error, mostrar directamente el formulario de login
    <?php if (isset($errMsg)) { ?>
      document.addEventListener('DOMContentLoaded', function() {
        showLoginForm();
      });
    <?php } ?>
  </script>
</body>
</html>
