<?php
    ob_start();
     // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar permisos
    if(!hasModulePermission('profesionales') && !hasSubmenuPermission('profesionales_lista')){
        header('location: ../acceso_denegado.php');
        exit;
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">



    <title>Clínica Salud | Crear perfil del del médico</title>
</head>
<body>

      <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>
 <!-- SIDEBAR -->

    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                 <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../medicos/mostrar.php">Listado de los médicos</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Crear perfil del del médico</a></li>
            </ul>
           
           <!-- multistep form -->
<?php 
require '../../backend/bd/Conexion.php';
 $id = $_GET['id'];
 $sentencia = $connect->prepare("SELECT * FROM doctor  WHERE idodc= '$id';");
 $sentencia->execute();

$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
   ?>
   <?php if(count($data)>0):?>
        <?php foreach($data as $d):?>

<form action="" enctype="multipart/form-data" method="POST"  autocomplete="off" onsubmit="return validacion()">
  <div class="containerss">
    <h1>Crear perfil del del médico</h1>
    <?php include_once '../../backend/php/add_profileM.php' ?>
   <br>
    <hr>

    <label for="psw"><b>Nombre y apellidos del médico</b></label><span class="badge-warning">*</span>
    <input type="text"  placeholder="ejm: Juan Raul" value="<?php echo $d->nodoc; ?>  &nbsp; <?php echo $d->apdoc; ?>"  name="named" readonly required>
    <input type="hidden" name="mid" value="<?php echo $d->idodc; ?>">

    <label for="psw"><b>Correo electrónico del médico</b></label><span class="badge-warning">*</span>
    <input type="text"  placeholder="ejm: medico@gmail.com" name="come" required>

    <label for="psw"><b>Usuario del médico</b></label><span class="badge-warning">*</span>
    <input type="text"  placeholder="ejm: medicc" name="namedc" required>

    <label for="psw"><b>Contraseña del médico</b></label><span class="badge-warning">*</span>
    <input type="password"  name="pwdm"  required>

    <label for="psw"><b>Rol del Profesional</b></label><span class="badge-warning">*</span>
    <select required name="rlm" id="rolSelect" onchange="showPermissions()">
        <option value="">Seleccione un rol</option>
        <option value="3">Profesor</option>
        <option value="4">Psicólogo</option>
        <option value="5">Fisioterapeuta</option>
        <option value="6">Enfermería</option>
    </select>

    <!-- Sección de Permisos Granulares -->
    <div id="permissionsSection" style="display: none; margin-top: 20px; padding: 20px; background: #f8f9fc; border-radius: 8px; border: 2px solid #667eea;">
        <h3 style="color: #667eea; margin-bottom: 15px;">
            <i class='bx bx-shield-quarter'></i> Configurar Permisos de Acceso
        </h3>
        <p style="color: #666; font-size: 14px; margin-bottom: 20px;">
            Seleccione qué secciones del historial puede ver y modificar este profesional
        </p>

        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px;">
            <!-- Valoración del Riesgo Social -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">📋 Valoración del Riesgo Social</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_valoracion" value="1" style="margin-right: 8px;">
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_valoracion" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>

            <!-- Tamizaje Salud Oral -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">🦷 Tamizaje Salud Oral</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_salud_oral" value="1" style="margin-right: 8px;">
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_salud_oral" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>

            <!-- Tamizaje Salud Mental -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">🧠 Tamizaje Salud Mental</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_salud_mental" value="1" style="margin-right: 8px;">
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_salud_mental" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>

            <!-- Medicamentos -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">💊 Medicamentos</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_medicamentos" value="1" style="margin-right: 8px;">
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_medicamentos" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>

            <!-- Signos Vitales -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">💓 Signos Vitales</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_signos" value="1" style="margin-right: 8px;">
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_signos" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>

            <!-- Diagnóstico Médico -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">🩺 Diagnóstico Médico</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_diagnostico" value="1" style="margin-right: 8px;" checked>
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_diagnostico" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>

            <!-- Antecedentes -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">📝 Antecedentes</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_antecedentes" value="1" style="margin-right: 8px;" checked>
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_antecedentes" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>

            <!-- Exámenes -->
            <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                <h4 style="margin-bottom: 10px; color: #333;">🔬 Exámenes</h4>
                <label style="display: flex; align-items: center; margin-bottom: 8px; cursor: pointer;">
                    <input type="checkbox" name="perm_view_examenes" value="1" style="margin-right: 8px;" checked>
                    <span>Puede ver</span>
                </label>
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="perm_edit_examenes" value="1" style="margin-right: 8px;">
                    <span>Puede modificar</span>
                </label>
            </div>
        </div>

        <div style="margin-top: 15px; padding: 12px; background: #fff3cd; border-radius: 6px; border-left: 4px solid #ffc107;">
            <p style="margin: 0; font-size: 13px; color: #856404;">
                <strong>Nota:</strong> Los permisos de "modificar" solo funcionan si también tiene permiso de "ver".
            </p>
        </div>
    </div>

    <hr>
   
   <button type="submit" name="add_profileM" class="registerbtn">Guardar</button>
  </div>
  
</form>
<?php endforeach; ?>
  
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>

        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>


    <!-- NAVBAR -->
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    
    <script>
        function showPermissions() {
            const rolSelect = document.getElementById('rolSelect');
            const permissionsSection = document.getElementById('permissionsSection');
            
            // Mostrar permisos solo para roles 4, 5 y 6 (Psicólogo, Fisioterapeuta, Enfermería)
            if(rolSelect.value == '4' || rolSelect.value == '5' || rolSelect.value == '6') {
                permissionsSection.style.display = 'block';
                
                // Configurar permisos por defecto según el rol
                if(rolSelect.value == '6') {
                    // Enfermería - puede ver todo pero solo modificar signos vitales y medicamentos
                    document.querySelector('input[name="perm_view_valoracion"]').checked = true;
                    document.querySelector('input[name="perm_edit_valoracion"]').checked = false;
                    document.querySelector('input[name="perm_view_signos"]').checked = true;
                    document.querySelector('input[name="perm_edit_signos"]').checked = true;
                    document.querySelector('input[name="perm_view_medicamentos"]').checked = true;
                    document.querySelector('input[name="perm_edit_medicamentos"]').checked = true;
                    document.querySelector('input[name="perm_view_diagnostico"]').checked = true;
                    document.querySelector('input[name="perm_edit_diagnostico"]').checked = false;
                    document.querySelector('input[name="perm_view_antecedentes"]').checked = true;
                    document.querySelector('input[name="perm_edit_antecedentes"]').checked = false;
                    document.querySelector('input[name="perm_view_examenes"]').checked = true;
                    document.querySelector('input[name="perm_edit_examenes"]').checked = false;
                } else if(rolSelect.value == '4' || rolSelect.value == '5') {
                    // Psicólogo y Fisioterapeuta - acceso completo
                    document.querySelectorAll('#permissionsSection input[type="checkbox"]').forEach(cb => {
                        cb.checked = true;
                    });
                }
            } else {
                permissionsSection.style.display = 'none';
            }
        }
    </script>

   
</body>
</html>


