<?php
ob_start();
session_start();

if(!isset($_SESSION['rol']) || $_SESSION['rol'] != 1){
    header('location: ../login.php');
    exit();
}

require '../../backend/bd/Conexion.php';

$userId = isset($_GET['id']) ? $_GET['id'] : 0;

// Obtener datos del usuario
$stmtUser = $connect->prepare("SELECT * FROM users WHERE id = ?");
$stmtUser->execute([$userId]);
$user = $stmtUser->fetch(PDO::FETCH_ASSOC);

if(!$user) {
    header('location: mostrar.php');
    exit();
}

// Obtener permisos de menú actuales
$stmtMenuPerms = $connect->prepare("SELECT * FROM menu_permissions WHERE user_id = ?");
$stmtMenuPerms->execute([$userId]);
$menuPerms = $stmtMenuPerms->fetch(PDO::FETCH_ASSOC);

// Si no tiene permisos, usar valores por defecto según rol
if(!$menuPerms) {
    $menuPerms = [
        'dashboard' => 1,
        'remisiones' => 0,
        'remisiones_todas' => 0,
        'remisiones_nueva' => 0,
        'remisiones_calendario' => 0,
        'usuarios' => 0,
        'usuarios_lista' => 0,
        'usuarios_historial' => 0,
        'usuarios_documentos' => 0,
        'cursos' => 0,
        'cursos_registro' => 0,
        'cursos_inscripcion' => 0,
        'cursos_asistencia' => 0,
        'asistencia' => 0,
        'profesionales' => 0,
        'profesionales_lista' => 0,
        'profesionales_historial' => 0,
        'recursos' => 0,
        'recursos_enfermera' => 0,
        'recursos_laboratorios' => 0,
        'ajustes' => 0,
        'ajustes_config' => 0,
        'ajustes_idioma' => 0,
        'ajustes_base_datos' => 0,
        'acerca' => 1,
        'reportes' => 0
    ];
}

// Procesar formulario
if(isset($_POST['update_menu_permissions'])) {
    try {
        // Obtener columnas existentes en la tabla
        $columns = $connect->query("SHOW COLUMNS FROM menu_permissions")->fetchAll(PDO::FETCH_COLUMN);
        
        // Mapeo completo de permisos (incluye submenús)
        $permMap = [
            'dashboard' => 'perm_dashboard',
            'remisiones' => 'perm_remisiones',
            'remisiones_todas' => 'perm_remisiones_todas',
            'remisiones_nueva' => 'perm_remisiones_nueva',
            'remisiones_calendario' => 'perm_remisiones_calendario',
            'usuarios' => 'perm_usuarios',
            'usuarios_lista' => 'perm_usuarios_lista',
            'usuarios_historial' => 'perm_usuarios_historial',
            'usuarios_documentos' => 'perm_usuarios_documentos',
            // Permisos de Historia Clínica
            'historia_riesgo_social_ver' => 'perm_historia_riesgo_social_ver',
            'historia_riesgo_social_modificar' => 'perm_historia_riesgo_social_modificar',
            'historia_salud_oral_ver' => 'perm_historia_salud_oral_ver',
            'historia_salud_oral_modificar' => 'perm_historia_salud_oral_modificar',
            'historia_salud_mental_ver' => 'perm_historia_salud_mental_ver',
            'historia_salud_mental_modificar' => 'perm_historia_salud_mental_modificar',
            'historia_medicamentos_ver' => 'perm_historia_medicamentos_ver',
            'historia_medicamentos_modificar' => 'perm_historia_medicamentos_modificar',
            'historia_signos_vitales_ver' => 'perm_historia_signos_vitales_ver',
            'historia_signos_vitales_modificar' => 'perm_historia_signos_vitales_modificar',
            'historia_diagnostico_ver' => 'perm_historia_diagnostico_ver',
            'historia_diagnostico_modificar' => 'perm_historia_diagnostico_modificar',
            'historia_antecedentes_ver' => 'perm_historia_antecedentes_ver',
            'historia_antecedentes_modificar' => 'perm_historia_antecedentes_modificar',
            'historia_examenes_ver' => 'perm_historia_examenes_ver',
            'historia_examenes_modificar' => 'perm_historia_examenes_modificar',
            'historia_fisioterapia_ver' => 'perm_historia_fisioterapia_ver',
            'historia_fisioterapia_modificar' => 'perm_historia_fisioterapia_modificar',
            'cursos' => 'perm_cursos',
            'cursos_registro' => 'perm_cursos_registro',
            'cursos_inscripcion' => 'perm_cursos_inscripcion',
            'cursos_asistencia' => 'perm_cursos_asistencia',
            'asistencia' => 'perm_asistencia',
            'profesionales' => 'perm_profesionales',
            'profesionales_lista' => 'perm_profesionales_lista',
            'profesionales_historial' => 'perm_profesionales_historial',
            'recursos' => 'perm_recursos',
            'recursos_enfermera' => 'perm_recursos_enfermera',
            'recursos_laboratorios' => 'perm_recursos_laboratorios',
            'ajustes' => 'perm_ajustes',
            'ajustes_config' => 'perm_ajustes_config',
            'ajustes_idioma' => 'perm_ajustes_idioma',
            'ajustes_base_datos' => 'perm_ajustes_base_datos',
            'acerca' => 'perm_acerca',
            'reportes' => 'perm_reportes'
        ];
        
        // Verificar si ya existe un registro
        $checkPerms = $connect->prepare("SELECT id FROM menu_permissions WHERE user_id = ?");
        $checkPerms->execute([$userId]);
        $exists = $checkPerms->fetch();
        
        if($exists) {
            // Actualizar permisos existentes - solo columnas que existen
            $updateParts = [];
            $updateParams = [];
            
            foreach($permMap as $column => $postKey) {
                if(in_array($column, $columns)) {
                    $updateParts[] = "$column = ?";
                    $updateParams[] = isset($_POST[$postKey]) ? 1 : 0;
                }
            }
            
            $updateParams[] = $userId; // WHERE user_id
            
            $sql = "UPDATE menu_permissions SET " . implode(', ', $updateParts) . " WHERE user_id = ?";
            $updatePerms = $connect->prepare($sql);
            $updatePerms->execute($updateParams);
        } else {
            // Insertar nuevos permisos - solo columnas que existen
            $insertColumns = ['user_id'];
            $insertValues = ['?'];
            $insertParams = [$userId];
            
            foreach($permMap as $column => $postKey) {
                if(in_array($column, $columns)) {
                    $insertColumns[] = $column;
                    $insertValues[] = '?';
                    $insertParams[] = isset($_POST[$postKey]) ? 1 : 0;
                }
            }
            
            $sql = "INSERT INTO menu_permissions (" . implode(', ', $insertColumns) . ") VALUES (" . implode(', ', $insertValues) . ")";
            $insertPerms = $connect->prepare($sql);
            $insertPerms->execute($insertParams);
        }
        
        $successMessage = "Permisos de menú actualizados correctamente";
        
        // Recargar permisos
        $stmtMenuPerms->execute([$userId]);
        $menuPerms = $stmtMenuPerms->fetch(PDO::FETCH_ASSOC);
        
    } catch(PDOException $e) {
        $errorMessage = "Error al actualizar permisos: " . $e->getMessage();
    }
}

$roles = [1 => 'Administrador', 3 => 'Profesor', 4 => 'Psicólogo', 5 => 'Fisioterapeuta', 6 => 'Enfermería'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <title>Editar Menú | <?php echo $user['name']; ?></title>
</head>
<body>
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <section id="content">
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Profile</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Logout</a></li>
                </ul>
            </div>
        </nav>

        <main>
            <h1 class="title">Configurar Menú Lateral</h1>
            <ul class="breadcrumbs">
                <li><a href="../dashboard.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="mostrar.php">Profesionales</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Editar Menú</a></li>
            </ul>

            <?php if(isset($successMessage)): ?>
            <div style="background: #e6f7ee; padding: 15px; border-radius: 8px; border-left: 4px solid #28a745; margin-bottom: 20px;">
                <p style="margin: 0; color: #155724;"><strong>✅ <?php echo $successMessage; ?></strong></p>
            </div>
            <?php endif; ?>

            <?php if(isset($errorMessage)): ?>
            <div style="background: #fee; padding: 15px; border-radius: 8px; border-left: 4px solid #c33; margin-bottom: 20px;">
                <p style="margin: 0; color: #721c24;"><strong>❌ <?php echo $errorMessage; ?></strong></p>
            </div>
            <?php endif; ?>

            <div class="data">
                <div class="content-data">
                    <div class="head">
                        <h3>👤 <?php echo $user['name']; ?></h3>
                        <p style="margin: 5px 0 0 0; color: #666;">
                            <strong>Usuario:</strong> <?php echo $user['username']; ?> | 
                            <strong>Rol:</strong> <?php echo $roles[$user['rol']] ?? 'Desconocido'; ?>
                        </p>
                    </div>

                    <form method="POST" style="padding: 20px;">
                        <div style="background: #f8f9fc; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
                            <h3 style="margin-top: 0; color: #667eea;">📋 Configurar Módulos del Menú</h3>
                            <p style="color: #666; margin-bottom: 20px;">
                                Seleccione qué módulos aparecerán en el menú lateral para este usuario
                            </p>

                            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;">
                                <!-- Dashboard -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_dashboard" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['dashboard'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>📊 Dashboard</strong></span>
                                    </label>
                                </div>

                                <!-- Remisiones -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 10px;">
                                        <input type="checkbox" name="perm_remisiones" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['remisiones'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>📋 Remisiones</strong></span>
                                    </label>
                                    <div style="margin-left: 28px; border-left: 2px solid #e8e8e8; padding-left: 10px;">
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_remisiones_todas" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['remisiones_todas']) && $menuPerms['remisiones_todas'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Todas las Remisiones</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_remisiones_nueva" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['remisiones_nueva']) && $menuPerms['remisiones_nueva'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Nueva</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_remisiones_calendario" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['remisiones_calendario']) && $menuPerms['remisiones_calendario'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Calendario</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Usuarios -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 10px;">
                                        <input type="checkbox" name="perm_usuarios" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['usuarios'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>👥 Usuarios</strong></span>
                                    </label>
                                    <div style="margin-left: 28px; border-left: 2px solid #e8e8e8; padding-left: 10px;">
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_usuarios_lista" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['usuarios_lista']) && $menuPerms['usuarios_lista'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Lista de Usuarios</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_usuarios_historial" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['usuarios_historial']) && $menuPerms['usuarios_historial'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Historial de los Usuarios</span>
                                        </label>
                                        
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_usuarios_documentos" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['usuarios_documentos']) && $menuPerms['usuarios_documentos'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Documentos</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Cursos -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 10px;">
                                        <input type="checkbox" name="perm_cursos" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['cursos'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>📚 Cursos</strong></span>
                                    </label>
                                    <div style="margin-left: 28px; border-left: 2px solid #e8e8e8; padding-left: 10px;">
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_cursos_registro" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['cursos_registro']) && $menuPerms['cursos_registro'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Registro Cursos</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_cursos_inscripcion" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['cursos_inscripcion']) && $menuPerms['cursos_inscripcion'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Inscripción Cursos</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_cursos_asistencia" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['cursos_asistencia']) && $menuPerms['cursos_asistencia'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Asistencia</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Asistencia -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_asistencia" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['asistencia'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>📅 Asistencia</strong></span>
                                    </label>
                                    <p style="margin: 8px 0 0 28px; font-size: 12px; color: #666;">Control de asistencia</p>
                                </div>

                                <!-- Profesionales -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 10px;">
                                        <input type="checkbox" name="perm_profesionales" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['profesionales'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>👨‍⚕️ Profesionales</strong></span>
                                    </label>
                                    <div style="margin-left: 28px; border-left: 2px solid #e8e8e8; padding-left: 10px;">
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_profesionales_lista" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['profesionales_lista']) && $menuPerms['profesionales_lista'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Lista de Profesionales</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_profesionales_historial" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['profesionales_historial']) && $menuPerms['profesionales_historial'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Historial de los Profesionales</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Recursos Humanos -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 10px;">
                                        <input type="checkbox" name="perm_recursos" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['recursos'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>👥 Recursos Humanos</strong></span>
                                    </label>
                                    <div style="margin-left: 28px; border-left: 2px solid #e8e8e8; padding-left: 10px;">
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_recursos_enfermera" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['recursos_enfermera']) && $menuPerms['recursos_enfermera'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Enfermera</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_recursos_laboratorios" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['recursos_laboratorios']) && $menuPerms['recursos_laboratorios'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Laboratorios</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Ajustes -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 10px;">
                                        <input type="checkbox" name="perm_ajustes" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['ajustes'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>⚙️ Ajustes</strong></span>
                                    </label>
                                    <div style="margin-left: 28px; border-left: 2px solid #e8e8e8; padding-left: 10px;">
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_ajustes_config" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['ajustes_config']) && $menuPerms['ajustes_config'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Ajustes</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 5px;">
                                            <input type="checkbox" name="perm_ajustes_idioma" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['ajustes_idioma']) && $menuPerms['ajustes_idioma'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Idioma</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_ajustes_base_datos" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['ajustes_base_datos']) && $menuPerms['ajustes_base_datos'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">Base de datos</span>
                                        </label>
                                    </div>
                                </div>

                                <!-- Acerca de -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_acerca" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['acerca'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>ℹ️ Acerca de</strong></span>
                                    </label>
                                    <p style="margin: 8px 0 0 28px; font-size: 12px; color: #666;">Información del sistema</p>
                                </div>

                                <!-- Reportes -->
                                <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e8e8e8;">
                                    <label style="display: flex; align-items: center; cursor: pointer;">
                                        <input type="checkbox" name="perm_reportes" value="1" style="margin-right: 10px; width: 18px; height: 18px;" <?php echo $menuPerms['reportes'] ? 'checked' : ''; ?>>
                                        <span style="font-size: 16px;"><strong>📊 Reportes</strong></span>
                                    </label>
                                    <p style="margin: 8px 0 0 28px; font-size: 12px; color: #666;">Estadísticas y reportes</p>
                                </div>
                            </div>

                            <!-- Permisos de Historia Clínica (sección separada) -->
                            <div id="historiaClinicaPermisos" style="margin-top: 20px; padding: 20px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border-radius: 12px; border: 2px solid #667eea; display: none;">
                                <h3 style="margin: 0 0 15px 0; color: #667eea; display: flex; align-items: center; gap: 10px;">
                                    <span style="font-size: 24px;">📋</span>
                                    <span>Permisos de Historia Clínica</span>
                                </h3>
                                <p style="margin: 0 0 20px 0; color: #666; font-size: 14px;">
                                    Seleccione qué secciones de la historia clínica puede ver y/o modificar este usuario
                                </p>
                                
                                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 15px;">
                                    <!-- Valoración del Riesgo Social -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>📊</span> Valoración Riesgo Social
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_riesgo_social_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_riesgo_social_ver']) && $menuPerms['historia_riesgo_social_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_riesgo_social_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_riesgo_social_modificar']) && $menuPerms['historia_riesgo_social_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Tamizaje Salud Oral -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>🦷</span> Tamizaje Salud Oral
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_salud_oral_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_salud_oral_ver']) && $menuPerms['historia_salud_oral_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_salud_oral_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_salud_oral_modificar']) && $menuPerms['historia_salud_oral_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Tamizaje Salud Mental -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>🧠</span> Tamizaje Salud Mental
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_salud_mental_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_salud_mental_ver']) && $menuPerms['historia_salud_mental_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_salud_mental_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_salud_mental_modificar']) && $menuPerms['historia_salud_mental_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Medicamentos -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>💊</span> Medicamentos
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_medicamentos_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_medicamentos_ver']) && $menuPerms['historia_medicamentos_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_medicamentos_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_medicamentos_modificar']) && $menuPerms['historia_medicamentos_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Signos Vitales -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>❤️</span> Signos Vitales
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_signos_vitales_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_signos_vitales_ver']) && $menuPerms['historia_signos_vitales_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_signos_vitales_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_signos_vitales_modificar']) && $menuPerms['historia_signos_vitales_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Diagnóstico Médico -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>🩺</span> Diagnóstico Médico
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_diagnostico_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_diagnostico_ver']) && $menuPerms['historia_diagnostico_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_diagnostico_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_diagnostico_modificar']) && $menuPerms['historia_diagnostico_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Antecedentes -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>📝</span> Antecedentes
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_antecedentes_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_antecedentes_ver']) && $menuPerms['historia_antecedentes_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_antecedentes_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_antecedentes_modificar']) && $menuPerms['historia_antecedentes_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Exámenes -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>🔬</span> Exámenes
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_examenes_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_examenes_ver']) && $menuPerms['historia_examenes_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_examenes_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_examenes_modificar']) && $menuPerms['historia_examenes_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                    
                                    <!-- Fisioterapia -->
                                    <div style="background: white; padding: 15px; border-radius: 8px; border: 1px solid #e0e0e0; box-shadow: 0 2px 4px rgba(0,0,0,0.05);">
                                        <p style="margin: 0 0 10px 0; font-size: 14px; font-weight: bold; color: #333; display: flex; align-items: center; gap: 8px;">
                                            <span>🏃</span> Fisioterapia
                                        </p>
                                        <label style="display: flex; align-items: center; cursor: pointer; margin-bottom: 8px;">
                                            <input type="checkbox" name="perm_historia_fisioterapia_ver" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_fisioterapia_ver']) && $menuPerms['historia_fisioterapia_ver'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✓ Puede ver</span>
                                        </label>
                                        <label style="display: flex; align-items: center; cursor: pointer;">
                                            <input type="checkbox" name="perm_historia_fisioterapia_modificar" value="1" style="margin-right: 8px; width: 16px; height: 16px;" <?php echo isset($menuPerms['historia_fisioterapia_modificar']) && $menuPerms['historia_fisioterapia_modificar'] ? 'checked' : ''; ?>>
                                            <span style="font-size: 13px;">✎ Puede modificar</span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div style="margin-top: 15px; padding: 12px; background: #fff3cd; border-radius: 6px; border-left: 4px solid #ffc107;">
                                <p style="margin: 0; font-size: 13px; color: #856404;">
                                    <strong>Nota:</strong> Los módulos desmarcados no aparecerán en el menú lateral del usuario.
                                </p>
                            </div>
                        </div>

                        <div style="display: flex; gap: 10px;">
                            <button type="submit" name="update_menu_permissions" class="registerbtn" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                💾 Guardar Cambios
                            </button>
                            <a href="mostrar.php" class="button" style="background: #6c757d; color: white; text-decoration: none; padding: 12px 30px; border-radius: 8px; display: inline-block;">
                                ← Volver
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </section>

    <script src="../../backend/js/script.js"></script>
    <script>
        // Mostrar/ocultar permisos de Historia Clínica según checkbox de Historial
        document.addEventListener('DOMContentLoaded', function() {
            const historialCheckbox = document.querySelector('input[name="perm_usuarios_historial"]');
            const historiaClinicaDiv = document.getElementById('historiaClinicaPermisos');
            
            // Función para mostrar/ocultar
            function toggleHistoriaClinica() {
                if(historialCheckbox.checked) {
                    historiaClinicaDiv.style.display = 'block';
                } else {
                    historiaClinicaDiv.style.display = 'none';
                }
            }
            
            // Ejecutar al cargar la página
            toggleHistoriaClinica();
            
            // Ejecutar cuando cambie el checkbox
            historialCheckbox.addEventListener('change', toggleHistoriaClinica);
        });
    </script>
</body>
</html>
