<?php
    ob_start();
     // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar permisos
    if(!hasModulePermission('profesionales') && !hasSubmenuPermission('profesionales_lista')){
        header('location: ../acceso_denegado.php');
        exit;
    }
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">



    <title>Clínica Salud | Nuevo médico</title>
</head>
<body>

       <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>


    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
            <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../medicos/mostrar.php">Listado de los Profesionales</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Nuevo Profesional</a></li>
            </ul>
           
           <!-- multistep form -->


<form action="" enctype="multipart/form-data" method="POST"  autocomplete="off" onsubmit="return validacion()">
  <div class="containerss">
    <h1>Nuevo Profesional</h1>
    <?php include_once '../../backend/php/add_doctor.php' ?>
    <div class="alert-danger">
  <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
  <strong>Importante!</strong> Es importante rellenar los campos con &nbsp;<span class="badge-warning">*</span>
</div>
    <hr>

    <label for="email"><b>Cédula del Profesional</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: 09741478" name="cem" maxlength="8" required>

    <label for="psw"><b>Nombre del Profesional</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Juan Raul" name="named" required>

    <label for="psw"><b>Apellido del Profesional</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Ramirez Requena" name="apeme" required>

    <label for="psw"><b>Dirección del Profesional</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: calle los medanos" name="dime" required>

    <label for="psw"><b>Género del Profesional</b></label><span class="badge-warning">*</span>
    <select required name="geme" id="gep">
        <option>Seleccione</option>
        <option value="Masculino">Masculino</option>
        <option value="Femenino">Femenino</option>
    </select>

    <label for="psw"><b>Especialidad del Profesional</b></label><span class="badge-warning">*</span>
    <select required name="espm" id="espm">
        <option>Seleccione</option>
        <option value="Pediatría">Pediatría</option>
        <option value="Rehabilitación">Rehabilitación</option>
        <option value="Endocrinología">Endocrinología</option>
        <option value="Cardiología">Cardiología</option>
        <option value="Dermatología">Dermatología</option>
        <option value="Gastroenterología">Gastroenterología</option>
        <option value="Psiquiatría">Psiquiatría</option>
        <option value="Neurología">Neurología</option>
        <option value="Neumología">Neumología</option>
        <option value="Reumatología">Reumatología</option>
        <option value="Hematología">Hematología</option>
        <option value="Oncología">Oncología</option>
    </select>


    <label for="psw"><b>Teléfono del Profesional</b></label><span class="badge-warning">*</span>
    <input type="text" maxlength="13" placeholder="ejm: +51 999 888 111" name="telme" required>

    <label for="psw"><b>Fecha de nacimiento del Profesional</b></label><span class="badge-warning">*</span>
    <input type="date" name="cumme" required>

    <hr>
   
    <button type="submit" name="add_doctor" class="registerbtn">Guardar</button>
  </div>
  
</form>

        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>


    <!-- NAVBAR -->
    
    <script src="../../backend/js/script.js"></script>
    <script src="../../backend/js/multistep.js"></script>
    <script src="../../backend/js/vpat.js"></script>
    

    <script type="text/javascript">
    let popUp = document.getElementById("cookiePopup");
//When user clicks the accept button
document.getElementById("acceptCookie").addEventListener("click", () => {
  //Create date object
  let d = new Date();
  //Increment the current time by 1 minute (cookie will expire after 1 minute)
  d.setMinutes(2 + d.getMinutes());
  //Create Cookie withname = myCookieName, value = thisIsMyCookie and expiry time=1 minute
  document.cookie = "myCookieName=thisIsMyCookie; expires = " + d + ";";
  //Hide the popup
  popUp.classList.add("hide");
  popUp.classList.remove("shows");
});
//Check if cookie is already present
const checkCookie = () => {
  //Read the cookie and split on "="
  let input = document.cookie.split("=");
  //Check for our cookie
  if (input[0] == "myCookieName") {
    //Hide the popup
    popUp.classList.add("hide");
    popUp.classList.remove("shows");
  } else {
    //Show the popup
    popUp.classList.add("shows");
    popUp.classList.remove("hide");
  }
};
//Check if cookie exists when page loads
window.onload = () => {
  setTimeout(() => {
    checkCookie();
  }, 2000);
};
    </script>
   
</body>
</html>


