<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Solo admin y profesionales pueden aprobar
    if($_SESSION['rol'] != 1 && $_SESSION['rol'] != 2) {
        header('location: ../acceso_denegado.php');
        exit();
    }
    
    require '../../backend/bd/Conexion.php';
    
    $id = $_SESSION['id'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    
    <!-- Data Tables -->
    <link rel="stylesheet" type="text/css" href="../../backend/css/datatable.css">
    <link rel="stylesheet" type="text/css" href="../../backend/css/buttonsdataTables.css">
    <link rel="stylesheet" type="text/css" href="../../backend/css/font.css">
    
    <title>Aprobar Ciudadanos | Programa Persona Mayor</title>
    
    <style>
        .estado-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            display: inline-block;
        }
        
        .estado-pendiente {
            background: #fff3cd;
            color: #856404;
        }
        
        .estado-aprobado {
            background: #d4edda;
            color: #155724;
        }
        
        .estado-rechazado {
            background: #f8d7da;
            color: #721c24;
        }
        
        .btn-aprobar {
            background: #28a745;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.2s;
        }
        
        .btn-aprobar:hover {
            background: #218838;
            transform: scale(1.05);
        }
        
        .btn-rechazar {
            background: #dc3545;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.2s;
        }
        
        .btn-rechazar:hover {
            background: #c82333;
            transform: scale(1.05);
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
        }
        
        .modal-content {
            background-color: white;
            margin: 10% auto;
            padding: 30px;
            border-radius: 12px;
            width: 90%;
            max-width: 500px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.3);
        }
        
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        
        .close:hover {
            color: #000;
        }
    </style>
</head>
<body>
    <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <!-- CONTENT -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Buscar...">
                    <i class='bx bx-search icon'></i>
                </div>
            </form>
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Cerrar Sesión</a></li>
                </ul>
            </div>
        </nav>

        <!-- MAIN -->
        <main>
            <h1 class="title">Aprobar Ciudadanos</h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Aprobar Ciudadanos</a></li>
            </ul>
            
            <!-- Filtros -->
            <div style="background: white; padding: 20px; border-radius: 12px; margin-bottom: 20px;">
                <label for="filtroEstado" style="font-weight: 600; margin-right: 10px;">Filtrar por Estado:</label>
                <select id="filtroEstado" style="padding: 8px 15px; border: 2px solid #e8e8e8; border-radius: 6px; font-size: 14px; min-width: 200px;">
                    <option value="">Todos</option>
                    <option value="pendiente" selected>Pendientes</option>
                    <option value="aprobado">Aprobados</option>
                    <option value="rechazado">Rechazados</option>
                </select>
            </div>
            
            <div class="data">
                <div class="content-data">
                    <div class="head">
                        <h3>Ciudadanos Registrados</h3>
                    </div>
                    
                    <div class="table-responsive" style="overflow-x:auto;">
                        <?php 
                        $sentencia = $connect->prepare("
                            SELECT u.*, p.numhs, p.nompa, p.apepa, p.phon, p.sex,
                                   aprobador.name as nombre_aprobador
                            FROM users u
                            LEFT JOIN patients p ON u.username = p.numhs
                            LEFT JOIN users aprobador ON u.aprobado_por = aprobador.id
                            WHERE u.rol = 3
                            ORDER BY 
                                CASE u.aprobado
                                    WHEN 'pendiente' THEN 1
                                    WHEN 'aprobado' THEN 2
                                    WHEN 'rechazado' THEN 3
                                END,
                                u.created_at DESC
                        ");
                        $sentencia->execute();
                        $data = $sentencia->fetchAll(PDO::FETCH_ASSOC);
                        ?>
                        
                        <?php if(count($data) > 0): ?>
                            <table id="example" class="responsive-table">
                                <thead>
                                    <tr>
                                        <th>Usuario</th>
                                        <th>Nombre Completo</th>
                                        <th>Documento</th>
                                        <th>Teléfono</th>
                                        <th>Fecha Registro</th>
                                        <th>Estado</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($data as $d): ?>
                                        <tr data-estado="<?php echo $d['aprobado'] ?? 'pendiente'; ?>">
                                            <td><?php echo htmlspecialchars($d['username']); ?></td>
                                            <td><?php echo htmlspecialchars($d['nompa'] . ' ' . $d['apepa']); ?></td>
                                            <td><?php echo htmlspecialchars($d['numhs'] ?? 'N/A'); ?></td>
                                            <td><?php echo htmlspecialchars($d['phon'] ?? 'N/A'); ?></td>
                                            <td><?php echo date('d/m/Y H:i', strtotime($d['created_at'])); ?></td>
                                            <td>
                                                <?php 
                                                $estado = $d['aprobado'] ?? 'pendiente';
                                                $claseEstado = 'estado-' . $estado;
                                                $textoEstado = ucfirst($estado);
                                                ?>
                                                <span class="estado-badge <?php echo $claseEstado; ?>">
                                                    <?php echo $textoEstado; ?>
                                                </span>
                                                <?php if($estado == 'aprobado' && $d['nombre_aprobador']): ?>
                                                    <br><small style="color: #666;">Por: <?php echo htmlspecialchars($d['nombre_aprobador']); ?></small>
                                                <?php endif; ?>
                                                <?php if($estado == 'rechazado' && $d['motivo_rechazo']): ?>
                                                    <br><small style="color: #dc3545;">Motivo: <?php echo htmlspecialchars($d['motivo_rechazo']); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($estado == 'pendiente'): ?>
                                                    <button onclick="aprobarCiudadano(<?php echo $d['id']; ?>, '<?php echo htmlspecialchars($d['username']); ?>')" class="btn-aprobar">
                                                        <i class='bx bx-check'></i> Aprobar
                                                    </button>
                                                    <button onclick="mostrarModalRechazo(<?php echo $d['id']; ?>, '<?php echo htmlspecialchars($d['username']); ?>')" class="btn-rechazar">
                                                        <i class='bx bx-x'></i> Rechazar
                                                    </button>
                                                <?php elseif($estado == 'rechazado'): ?>
                                                    <button onclick="aprobarCiudadano(<?php echo $d['id']; ?>, '<?php echo htmlspecialchars($d['username']); ?>')" class="btn-aprobar">
                                                        <i class='bx bx-check'></i> Aprobar
                                                    </button>
                                                <?php else: ?>
                                                    <button onclick="revocarAprobacion(<?php echo $d['id']; ?>, '<?php echo htmlspecialchars($d['username']); ?>')" class="btn-rechazar">
                                                        <i class='bx bx-x'></i> Revocar
                                                    </button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            <div class="alert">
                                <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>
                                <strong>Info:</strong> No hay ciudadanos registrados.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>
    </section>

    <!-- Modal de Rechazo -->
    <div id="modalRechazo" class="modal">
        <div class="modal-content">
            <span class="close" onclick="cerrarModal()">&times;</span>
            <h2 style="margin-top: 0;">Rechazar Ciudadano</h2>
            <p>¿Estás seguro de rechazar a <strong id="nombreCiudadano"></strong>?</p>
            <form id="formRechazo" method="POST" action="../../backend/php/procesar_aprobacion.php">
                <input type="hidden" name="user_id" id="userId">
                <input type="hidden" name="accion" value="rechazar">
                
                <label style="display: block; margin: 15px 0 5px 0; font-weight: 600;">Motivo del rechazo:</label>
                <textarea name="motivo_rechazo" required rows="4" style="width: 100%; padding: 10px; border: 2px solid #e8e8e8; border-radius: 6px; font-size: 14px;" placeholder="Explica por qué se rechaza este ciudadano..."></textarea>
                
                <div style="margin-top: 20px; text-align: right;">
                    <button type="button" onclick="cerrarModal()" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 6px; margin-right: 10px; cursor: pointer;">Cancelar</button>
                    <button type="submit" class="btn-rechazar">Rechazar Ciudadano</button>
                </div>
            </form>
        </div>
    </div>

    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
    
    <!-- Data Tables -->
    <script type="text/javascript" src="../../backend/js/datatable.js"></script>
    <script type="text/javascript" src="../../backend/js/datatablebuttons.js"></script>
    <script type="text/javascript" src="../../backend/js/jszip.js"></script>
    <script type="text/javascript" src="../../backend/js/pdfmake.js"></script>
    <script type="text/javascript" src="../../backend/js/vfs_fonts.js"></script>
    <script type="text/javascript" src="../../backend/js/buttonshtml5.js"></script>
    <script type="text/javascript" src="../../backend/js/buttonsprint.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#example').DataTable({
                dom: 'Bfrtip',
                buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
                order: [[5, 'asc']] // Ordenar por estado
            });
            
            // Filtro por estado
            $('#filtroEstado').on('change', function() {
                var estadoSeleccionado = $(this).val().toLowerCase();
                
                $('#example tbody tr').each(function() {
                    var estadoFila = $(this).attr('data-estado').toLowerCase();
                    
                    if (estadoSeleccionado === '' || estadoFila === estadoSeleccionado) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
            
            // Aplicar filtro inicial (pendientes)
            $('#filtroEstado').trigger('change');
        });
        
        function aprobarCiudadano(userId, username) {
            if(confirm('¿Aprobar a ' + username + ' para acceder al programa?')) {
                window.location.href = '../../backend/php/procesar_aprobacion.php?user_id=' + userId + '&accion=aprobar';
            }
        }
        
        function revocarAprobacion(userId, username) {
            if(confirm('¿Revocar la aprobación de ' + username + '?')) {
                window.location.href = '../../backend/php/procesar_aprobacion.php?user_id=' + userId + '&accion=revocar';
            }
        }
        
        function mostrarModalRechazo(userId, username) {
            document.getElementById('userId').value = userId;
            document.getElementById('nombreCiudadano').textContent = username;
            document.getElementById('modalRechazo').style.display = 'block';
        }
        
        function cerrarModal() {
            document.getElementById('modalRechazo').style.display = 'none';
        }
        
        // Cerrar modal al hacer clic fuera
        window.onclick = function(event) {
            var modal = document.getElementById('modalRechazo');
            if (event.target == modal) {
                cerrarModal();
            }
        }
    </script>
</body>
</html>
