<?php
    ob_start();
    session_start();
    
    // Incluir sistema de control de acceso
    require '../../backend/php/check_access.php';
    
    // Verificar si tiene sesión activa
    if(!isset($_SESSION['rol']) || !isset($_SESSION['id'])){
        header('location: ../login.php');
        exit();
    }
    
    // Si no es admin, verificar permisos personalizados
    if($_SESSION['rol'] != 1) {
        // Verificar permiso para ver/editar usuarios
        if(!isset($_SESSION['menu_permissions']['usuarios_lista']) || $_SESSION['menu_permissions']['usuarios_lista'] != 1) {
            header('location: ../acceso_denegado.php');
            exit();
        }
    }
    
    $id = $_SESSION['id'];
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <link rel="icon" type="image/png" sizes="96x96" href="../../backend/img/ico.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/6.6.9/sweetalert2.min.css">

 <!-- QR -->
     <script src="https://cdn.jsdelivr.net/npm/qrcode@1.5.1/build/qrcode.min.js"></script>

    <title>Clínica Salud | Actualizar USUARIO</title>
</head>
<body>

       <!-- SIDEBAR -->
   <!-- SIDEBAR DINÁMICO -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>


    <!-- NAVBAR -->
    <section id="content">

        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar' ></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Search...">
                    <i class='bx bx-search icon' ></i>
                </div>
            </form>
            
           
            <span class="divider"></span>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon' ></i> Profile</a></li>
                    
                    <li>
                     <a href="../salir.php"><i class='bx bxs-log-out-circle' ></i> Logout</a>
                    </li>
                   
                </ul>
            </div>
        </nav>
        <!-- NAVBAR -->

        <!-- MAIN -->

        <main>
            <h1 class="title">Bienvenido <?php echo '<strong>'.$_SESSION['username'].'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="../admin/escritorio.php">Home</a></li>
                <li class="divider">></li>
                <li><a href="../pacientes/mostrar.php">Listado de los Usuarios</a></li>
                <li class="divider">></li>
                <li><a href="#" class="active">Actualizar USUARIO</a></li>
            </ul>
           
           <!-- multistep form -->
<?php 
require '../../backend/bd/Conexion.php';
 $id = $_GET['id'];
 $sentencia = $connect->prepare("SELECT * FROM patients  WHERE idpa= '$id';");
 $sentencia->execute();

$data =  array();
if($sentencia){
  while($r = $sentencia->fetchObject()){
    $data[] = $r;
  }
}
   ?>
   <?php if(count($data)>0):?>
        <?php foreach($data as $d):?>

<form action="" enctype="multipart/form-data" method="POST"  autocomplete="off">
  <div class="containerss">
    <h1>Actualizar USUARIO</h1>
    <?php include_once '../../backend/php/upd_patiens.php' ?>
  <br>
    <hr>

    

     <label for="psw"><b>modalidad</b></label><span class="badge-warning">*</span>
    <select required name="modalidad" id="modalidad">
    <option value="<?php echo $d->modalidad; ?>"><?php echo $d->modalidad; ?></option>
        <option>Seleccione</option>        
        <option value="Centro día La paz ">Centro día La paz </option>
        <option value="Centro día Bradamonte ">Centro día Bradamonte </option>
        <option value="Centro día Neruda G1">Centro día Neruda G1 </option>
        <option value="Centro día Neruda G2">Centro día Neruda G2 </option>
        <option value="Satélite san Miguel">Satélite san Miguel </option>
        <option value="Satélite perico">Satélite perico</option>
        <option value="Club Santa Isabel ">Club Santa Isabel</option>
        <option value="Club Renacer">Club Renacer </option>
        <option value="Club San José ">Club San José  </option>
        <option value="Club San Benito">Club San Benito  </option>
        <option value="Club San Rafael">Club San Rafael  </option>
        <option value="RAD">RAD</option>
        
    </select>  

    
<label for="psw"><b>Tipo de Usuario</b></label><span class="badge-warning">*</span>
    <select required name="tusuario" id="tusuario">
    <option value="<?php echo $d->tusuario; ?>"><?php echo $d->tusuario; ?></option>
        <option>Seleccione</option>
        <option value="Antiguo">Antiguo</option>
        <option value="Nuevo">Nuevo</option>
    </select>  

    <label for="psw"><b>Nombres del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Juan Raul" name="namp" value="<?php echo $d->nompa; ?>" required>

    <label for="psw"><b>Apellidos del USUARIO</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Ramirez Requena" value="<?php echo $d->apepa; ?>" name="apep" required>

 <label for="psw"><b>Tipó de Documento</b></label><span class="badge-warning">*</span>
    <select required name="tdocumento" id="tdocumento">
        <option value="">Seleccione</option>
        <option value="C.C" <?php 
            $tipoDocActual = strtoupper(str_replace('.', '', $d->tdocumento));
            echo ($tipoDocActual == 'CC' || $d->tdocumento == 'C.C') ? 'selected' : ''; 
        ?>>C.C</option>
        <option value="C.E" <?php 
            echo ($tipoDocActual == 'CE' || $d->tdocumento == 'C.E') ? 'selected' : ''; 
        ?>>C.E</option>
        <option value="SIN ID" <?php 
            echo (in_array($tipoDocActual, ['SINID', 'SIN_ID']) || $d->tdocumento == 'SIN ID') ? 'selected' : ''; 
        ?>>SIN ID</option>
    </select>  

    <label for="email"><b>Documento del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: 1012410744" value="<?php echo $d->numhs; ?>" name="nhi" maxlength="10" required>
    <input type="hidden" name="txthidpa" value="<?php echo $d->idpa; ?>">


    <label for="psw"><b>Fecha de Expedición</b></label><span class="badge-warning">*</span>
    <input type="date" placeholder="ejm: Juan Raul" name="fexpedicion" value="<?php 
    // Convertir formato DD/MM/YYYY a YYYY-MM-DD para input type="date"
    if (!empty($d->fexpedicion) && strpos($d->fexpedicion, '/') !== false) {
        $fecha_parts = explode('/', $d->fexpedicion);
        if (count($fecha_parts) == 3) {
            echo $fecha_parts[2] . '-' . $fecha_parts[1] . '-' . $fecha_parts[0];
        } else {
            echo $d->fexpedicion;
        }
    } else {
        echo $d->fexpedicion;
    }
    ?>" required>


    <label for="psw"><b>Lugar Expedición</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: Bogota" name="lexpedicion" value="<?php echo $d->lexpedicion; ?>" required>

    <label for="psw"><b>Fecha de nacimiento del usuario</b></label><span class="badge-warning">*</span>
    <input type="date" value="<?php echo $d->cump; ?>" name="cump" required>


<label for="fotoperfil"><b>Foto de Perfil</b></label><span class="badge-warning">*</span>
<input type="file" name="fotoperfil" id="fotoperfil" accept="image/*">
<div id="preview-foto" style="margin-top: 10px;">
    <img 
        id="img-preview" 
        src="<?php echo isset($d->fotoperfil) ? '/hogar_abuelos/uploads/fotos_perfil/' . $d->fotoperfil : ''; ?>" 
        alt="Vista previa" 
        style="max-width: 200px; max-height: 200px; <?php echo isset($d->fotoperfil) ? '' : 'display: none;'; ?> border: 2px solid #27ae60; border-radius: 8px;">
</div>



    <label for="psw"><b>Grupo sanguíneo del USUARIO</b></label><span class="badge-warning">*</span>
    <select required name="grp" id="grp">
        <option value="<?php echo $d->grup; ?>"><?php echo $d->grup; ?></option>
        <option>-----------------------</option>
        <option value="A+">A+</option>
        <option value="A-">A-</option>
        <option value="O+">O+</option>
        <option value="O-">O-</option>
        <option value="AB+">AB-</option>
        <option value="AB-">AB-</option>
    </select>

    <label for="psw"><b>Estado Civil</b></label><span class="badge-warning">*</span>
    <select required name="ecivil" id="ecivil">
    <option value="<?php echo $d->ecivil; ?>"><?php echo $d->ecivil; ?></option>
        <option>Seleccione</option>
        <option value="casado">Casado</option>
        <option value="soltero">Soltero</option>
        <option value="Viudos">Viudos</option>
        <option value="Union Libre">Union Libre</option>
    </select>

<label for="psw"><b>Género del USUARIO</b></label><span class="badge-warning">*</span>
    <select required name="gep" id="gep">
        <option value="<?php echo $d->sex; ?>"><?php echo $d->sex; ?></option>
        <option>----------------------</option>
        <option value="Masculino">Masculino</option>
        <option value="Femenino">Femenino</option>
        <option value="Bisexual">Bisexual</option>
        <option value="Intersexual">Intersexual</option>
    </select>

    <label for="psw"><b>ZONA</b></label><span class="badge-warning">*</span>
    <select required name="zona" id="zona">
    <option value="<?php echo $d->zona; ?>"><?php echo $d->zona; ?></option>
        <option>Seleccione</option>
        <option value="Urbana">Urbana</option>
        <option value="Rural">Rural</option>
        <option value="Centro Poblado">Centro Poblado</option>
    </select>  

    <label for="psw"><b>BARRIO</b></label><span class="badge-warning">*</span>
    <select required name="barrio" id="barrio">
    <option value="<?php echo $d->barrio; ?>"><?php echo $d->barrio; ?></option>
        <option>Seleccione</option>
        <option value="La paz">La paz</option>
        <option value="La Inmaculada">La Inmaculada</option>
        <option value="Santa Isabel">Santa Isabel</option>
        <option value="parques del muña">parques del muña</option>
    </select>  

    <label for="psw"><b>Dirección del Usuario</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: calle los medanos" value="<?php echo $d->direc; ?>" name="dip" required>

        <label for="psw"><b>Teléfono del usuario</b></label><span class="badge-warning">*</span>
    <input type="text" maxlength="13" value="<?php echo $d->phon; ?>" placeholder="ejm: +51 999 888 111" name="telp" required>

    <label for="psw"><b>¿El usuario tiene WhatsApp?</b></label><span class="badge-warning">*</span>
    <select required name="tiene_whatsapp" id="tiene_whatsapp">
        <option value="<?php echo $d->tiene_whatsapp; ?>"><?php echo $d->tiene_whatsapp; ?></option>
        <option value="">Seleccione</option>
        <option value="SI">Sí</option>
        <option value="NO">No</option>
    </select>

    <label for="email"><b>correo</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: correo" value="<?php echo $d->correo; ?>" name="correo" required>
    
        
    <label for="psw"><b>sisben</b></label><span class="badge-warning">*</span>
    <select required name="sisben" id="sisben">
    <option value="<?php echo $d->sisben; ?>"><?php echo $d->sisben; ?></option>
        <option>Seleccione</option>
        <option value="A1">A1</option>
        <option value="A2">A2</option>
        <option value="A3">A3</option>
        <option value="A4">A4</option>
        <option value="A5">A5</option>
        <option value="B1">B1</option>
        <option value="B2">B2</option>
        <option value="B3">B3</option>
        <option value="B4">B4</option>
        <option value="B5">B5</option>
        <option value="B6">B6</option>
        <option value="B7">B7</option>
        <option value="C1">C1</option>
        <option value="C2">C2</option>
        <option value="C3">C3</option>
        <option value="C4">C4</option>
        <option value="C5">C5</option>
        <option value="C6">C6</option>
        <option value="C7">C7</option>
        <option value="C8">C8</option>
        <option value="C9">C9</option>
        <option value="10">10</option>
        <option value="C11">C11</option>
        <option value="C12">C12</option>
        <option value="C13">C13</option>
        <option value="C14">C14</option>
        <option value="C15">C15</option>
        <option value="C16">C16</option>
        <option value="C17">C17</option>
        <option value="C18">C18</option>
        <option value="D1">D1</option>
        <option value="D2">D2</option>
        <option value="D3">D3</option>
        <option value="D4">D4</option>
        <option value="D5">D5</option>
        <option value="D6">D6</option>
        <option value="D7">D7</option>
        <option value="D8">D8</option>
        <option value="D9">D9</option>
        <option value="D10">D10</option>
        <option value="D11">D11</option>
        <option value="D12">D12</option>
        <option value="D13">D13</option>
        <option value="D14">D14</option>
        <option value="D15">D15</option>
        <option value="D16">D16</option>
        <option value="D17">D17</option>
        <option value="D18">D18</option>
        <option value="D19">D19</option>
        <option value="D20">D20</option>
        <option value="D21">D21</option>
    </select>  

<label for="email"><b>Recibe Bono</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: rbono" value="<?php echo $d->rbono; ?>" name="rbono" required>
    
    <label for="email"><b>pensionado</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm: pensionado" value="<?php echo $d->pensionado; ?>" name="pensionado" required>
    
    <label for="email"><b>Talla sudadera</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:tsudadera" value="<?php echo $d->tsudadera; ?>" name="tsudadera" required>

    <label for="email"><b>Talla chaqueta</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:tchaqueta" value="<?php echo $d->tchaqueta; ?>" name="tchaqueta" required>
    
    <label for="email"><b>Talla zapatos</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:tzapatos" value="<?php echo $d->tzapatos; ?>" name="tzapatos" required>
    
    <label for="email"><b>¿ CUAL CONSIDERA USTED QUE ES SU MAYOR FORTALEZA O TALENTO ?</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:talentof" value="<?php echo $d->talentof; ?>" name="talentof" required>
    
    <label for="email"><b>EL ADULTO MAYOR INGRESA Y SE VA SOLO DE PROGRAMA</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:observacionsalida" value="<?php echo $d->observacionsalida; ?>" name="observacionsalida" required>
     <hr>

    <label for="email"><b>¿Con quien Vive?</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:vivecomp" value="<?php echo $d->vivecomp; ?>" name="vivecomp" required>
    <hr>

    <label for="email"><b>¿La persona Mayor considera que posee red de apoyo?</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:redapoyo" value="<?php echo $d->redapoyo; ?>" name="redapoyo" required>
    
    <label for="email"><b>Nombre  y apellido del Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:cuidador" value="<?php echo $d->cuidador; ?>" name="cuidador" required>
 
    <label for="psw"><b>Parentesco Cuidador</b></label><span class="badge-warning">*</span>
    <select required name="pcuidador" id="pcuidador">
    <option value="<?php echo $d->pcuidador; ?>"><?php echo $d->pcuidador; ?></option>
        <option>Seleccione</option>
        <option value="CÓNYUGE y/o COMPAÑERO">ACÓNYUGE y/o COMPAÑERO</option>
        <option value="Hijo">Hijo</option>
        <option value="Familia">Familia</option>
        <option value="Vecinoamigo">Vecino o Amigo</option>
        <option value="Institucional">Institucional</option>
    </select>

    <label for="psw"><b>Zona Cuidador</b></label><span class="badge-warning">*</span>
    <select required name="zcuidador" id="zcuidador">
    <option value="<?php echo $d->zcuidador; ?>"><?php echo $d->zcuidador; ?></option>
        <option>Seleccione</option>
        <option value="Urbano">Urbano</option>
        <option value="Rural">Rural</option>
        <option value="CentroP">Centro Poblado</option>
    </select>

    <label for="psw"><b>Barrio, Vereda, Centro Poblado</b></label><span class="badge-warning">*</span>
    <select required name="bvccuidador" id="bvccuidador">
    <option value="<?php echo $d->bvccuidador; ?>"><?php echo $d->bvccuidador; ?></option>
        <option>Seleccione</option>
        <option value="La Paz">La Paz</option>
        <option value="Parques del Muña">Parques del Muña</option>
        <option value="Reserva12">Reserva 12</option>
    </select>

    <label for="email"><b>Direccion del Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:dcuidador" value="<?php echo $d->dcuidador; ?>" name="dcuidador" required>
    
    <label for="email"><b>Telefono Cuidador</b></label><span class="badge-warning">*</span>
    <input type="text" placeholder="ejm:tcuidador" value="<?php echo $d->tcuidador; ?>" name="tcuidador" required>
    
    <label for="psw"><b>Que SGSSS</b></label><span class="badge-warning">*</span>
    <select required name="sgsss" id="sgsss">
    <option value="<?php echo $d->sgsss; ?>"><?php echo $d->sgsss; ?></option>
        <option>Seleccione</option>
        <option value="Contributivo">Contributivo</option>
        <option value="Subsidiado">Subsidiado</option>
        <option value="Regimen Especial">Regimen Especial</option>
        <option value="No Asegurado">No Asegurado</option>
    </select>

    <label for="psw"><b>Que EPS</b></label><span class="badge-warning">*</span>
    <select required name="eps" id="eps">
    <option value="<?php echo $d->eps; ?>"><?php echo $d->eps; ?></option>
        <option>Seleccione</option>
        <option value="SANITAS">SANITAS</option>
        <option value="SALUD TOTAL">SALUD TOTAL</option>
        <option value="Compensar">Compensar</option>
        <option value="Cruz verde">Cruz verde</option>
        <option value="Nueva EPS">Nueva EPS</option>
        <option value="Coosalud EPS-S">Coosalud EPS-S</option>
        <option value="Mutual SER">Mutual SER</option>
        <option value="Salud MIA">Salud MIA</option>
        <option value="Aliansalud EPS">Aliansalud EPS</option>
        <option value="Salud Total EPS S.A.">Salud Total EPS S.A.</option>
        <option value="EPS Sanitas">EPS Sanitas</option>
        <option value="EPS Sura">EPS Sura</option>
        <option value="Famisanar EPS">Famisanar EPS</option>
        <option value="Servicio Occidental de Salud EPS – SOS">Servicio Occidental de Salud EPS – SOS</option>
        <option value="Comfenalco Valle">Comfenalco Valle</option>
        <option value="Compensar EPS">Compensar EPS</option>
        <option value="Empresas Públicas de Medellín EPM">Empresas Públicas de Medellín EPM</option>
        <option value="Fondo de Pasivo Social de Ferrocarriles Nacionales de Colombia">Fondo de Pasivo Social de Ferrocarriles Nacionales de Colombia</option>
        <option value="Cajacopi Atlántico">Cajacopi Atlántico</option>
        <option value="Capresoca EPS">Capresoca EPS</option>
        <option value="Comfachocó">Comfachocó</option>
        <option value="Comfaoriente">Comfaoriente</option>
        <option value="EPS Familiar de Colombia">EPS Familiar de Colombia</option>
        <option value="Asmet Salud EPS">Asmet Salud EPS</option>
        <option value="Emssanar E.S.S.">Emssanar E.S.S.</option>
        <option value="Capital Salud EPS-S">Capital Salud EPS-S</option>
        <option value="Savia Salud EPS">Savia Salud EPS</option>
        <option value="Dusakawi EPSI">Dusakawi EPSI</option>
        <option value="Asociación Indígena del Cauca EPSI">Asociación Indígena del Cauca EPSI</option>
        <option value="Anas Wayuu EPSI">Anas Wayuu EPSI</option>
        <option value="Mallamas EPSI">Mallamas EPSI</option>
        <option value="Pijaos Salud EPSI">Pijaos Salud EPSI</option>
    </select>

    <label for="psw"><b>Que ETNIA</b></label><span class="badge-warning">*</span>
    <select required name="etnia" id="etnia">
    <option value="<?php echo $d->etnia; ?>"><?php echo $d->etnia; ?></option>
        <option>Seleccione</option>
        <option value="INDIGENA">INDIGENA</option>
        <option value="AFROCOLOMBIANO">AFRO COLOMBIANO</option>
        <option value="ROM-GITANO">ROM-GITANO</option>
        <option value="PALENQUERO">PALENQUERO</option>
        <option value="RAIZAL">RAIZAL</option>
        <option value="NINGUNO">NINGUNO</option>
    </select>

    <label for="psw"><b>Nivel Maximo Alcanzado</b></label><span class="badge-warning">*</span>
    <select required name="educacion" id="educacion">
    <option value="<?php echo $d->educacion; ?>"><?php echo $d->educacion; ?></option>
        <option>Seleccione</option>
        <option value="PRIMARIA">PRIMARIA</option>
        <option value="SECUNDARIA">SECUNDARIA</option>
        <option value="TECNICA">TECNICA</option>
        <option value="SUPERIOR">SUPERIOR </option>
        <option value="NINGUNO">NINGUNO </option>
    </select>

    
    <label for="psw"><b>Sabe leer y escribir</b></label><span class="badge-warning">*</span>
    <select required name="leer" id="leer">
    <option value="<?php echo $d->leer; ?>"><?php echo $d->leer; ?></option>
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>¿Hace uso de las tecnologias?</b></label><span class="badge-warning">*</span>
    <select required name="utecnologia" id="utecnologia">
    <option value="<?php echo $d->utecnologia; ?>"><?php echo $d->utecnologia; ?></option>
        <option>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>        
    </select>

    <label for="psw"><b>¿Hace parte de una poblaciòn diferencial o de inclusion?</b></label><span class="badge-warning">*</span>
    <select required name="poblaciond" id="poblaciond">
    <option value="<?php echo $d->poblaciond; ?>"><?php echo $d->poblaciond; ?></option>
        <option>Seleccione</option>
        <option value="discapacidad">discapacidad</option>
        <option value="situacion_especial">en situaciòn de proteccion especial</option>        
        <option value="desplazada">poblacion desplazada</option>
        <option value="vulnerable">En SItuaciòn de Vulneración</option>
        <option value="cuidado_terceros">Persona que se encuentra al cuidado de tercero</option>
        <option value="abandono">Situaciòn de abandono</option>
        <option value="habitante calle">Habitante de calle</option>
        <option value="victima">Victima del conflicto armado</option>
        <option value="Reinsertado">Reinsertado</option>
        <option value="ninguno">ninguno</option>
    </select>

    <label for="psw"><b>¿Hace parte de poblacion diferencial por oficio?</b></label><span class="badge-warning">*</span>
    <select required name="poblacionoficio" id="poblacionoficio">
    <option value="<?php echo $d->poblacionoficio; ?>"><?php echo $d->poblacionoficio; ?></option>
        <option>Seleccione</option>
        <option value="Reciclador">Reciclador</option>
        <option value="Bodegueros">Pequños Bodegueros</option>        
        <option value="vendedor">Vendedor Ambulante</option>
    </select>

    
    
    <!-- Sección QR -->
<label for="qrInput"><b>Genera tu Carnet</b></label><span class="badge-warning">*</span>
<div style="display: flex; align-items: center;">
    <input type="text" placeholder="qrInput" name="qrInput" id="qrInput" maxlength="8" required readonly>
    <button type="button" onclick="generateQR()" style="margin-left: 10px; padding: 5px 10px;">Generar QR</button>
</div>
<div id="qrCode" style="margin-top: 10px; text-align: center; font-family: Arial, sans-serif;"></div>

<!-- Botón de descarga (oculto inicialmente) -->
<button type="button" id="downloadQRBtn" style="display: none; margin: 10px 0; padding: 8px 15px; background: #27ae60; color: white; border: none; border-radius: 4px; cursor: pointer;">
    <i class='bx bx-download'></i> Descargar QR
</button>

    <hr>
   
    <button type="submit" name="upd_patiens" class="registerbtn">Guardar</button>
  </div>
  
</form>


        <?php endforeach; ?>
  
    <?php else:?>
      <p class="alert alert-warning">No hay datos</p>
    <?php endif; ?>

        </main>
        <!-- MAIN -->
    </section>
    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/admin.js"></script>

    <!-- NAVBAR -->
    <script type="text/javascript">
    let popUp = document.getElementById("cookiePopup");
//When user clicks the accept button
document.getElementById("acceptCookie").addEventListener("click", () => {
  //Create date object
  let d = new Date();
  //Increment the current time by 1 minute (cookie will expire after 1 minute)
  d.setMinutes(2 + d.getMinutes());
  //Create Cookie withname = myCookieName, value = thisIsMyCookie; expires = " + d + ";";
  document.cookie = "myCookieName=thisIsMyCookie; expires = " + d + ";";
  //Hide the popup
  popUp.classList.add("hide");
  popUp.classList.remove("shows");
});
//Check if cookie is already present
const checkCookie = () => {
  //Read the cookie and split on "="
  let input = document.cookie.split("=");
  //Check for our cookie
  if (input[0] == "myCookieName") {
    //Hide the popup
    popUp.classList.add("hide");
    popUp.classList.remove("shows");
  } else {
    //Show the popup
    popUp.classList.add("shows");
    popUp.classList.remove("hide");
  }
};
//Check if cookie exists when page loads
window.onload = () => {
  setTimeout(() => {
    checkCookie();
  }, 2000);
};
    </script>


<!-- Script para previsualizar la imagen -->
<script>
document.getElementById('fotoperfil').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById('img-preview');
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        reader.readAsDataURL(file);
    } else {
        preview.style.display = 'none';
    }
});
</script>




<!-- Script de generación QR modificado -->
<script>
    // Variable para almacenar el QR generado
    let currentQR = null;

    // Función para ajustar texto en múltiples líneas
    function wrapText(context, text, x, y, maxWidth, lineHeight) {
        const words = text.split(' ');
        let line = '';
        let currentY = y;
        
        for (let n = 0; n < words.length; n++) {
            const testLine = line + words[n] + ' ';
            const metrics = context.measureText(testLine);
            const testWidth = metrics.width;
            
            if (testWidth > maxWidth && n > 0) {
                context.fillText(line, x, currentY);
                line = words[n] + ' ';
                currentY += lineHeight;
            } else {
                line = testLine;
            }
        }
        context.fillText(line, x, currentY);
        return currentY;
    }


    // Función para generar QR (igual que en nuevo.php)
    function generateQR() {
        const documento = document.querySelector('input[name="nhi"]').value;
        const nombre = document.querySelector('input[name="namp"]').value;
        const apellido = document.querySelector('input[name="apep"]').value;
        const tipoDoc = document.querySelector('select[name="tdocumento"]').value;

        if (!documento || !nombre || !apellido) {
            alert("Por favor complete documento, nombre y apellido primero");
            return;
        }

        document.getElementById('qrInput').value = documento;
        const qrContainer = document.getElementById("qrCode");
        qrContainer.innerHTML = "<p>Generando QR...</p>";

        // Generar URL completa para el QR que incluye la cedula (igual que nuevo.php)
        const qrURL = `https://hogar_abuelos.n8nsibate.shop/ubicacion_abuelos/ubicar_abuelos.php?cedula=${documento}`;
        
        QRCode.toDataURL(qrURL, {
            width: 150,
            margin: 1,
            color: { dark: "#000000", light: "#FFFFFF" }
        }, function(error, url) {
            if (error) {
                qrContainer.innerHTML = "<p style='color:red;'>Error al generar QR</p>";
                return;
            }

            currentQR = url; // Almacenamos el QR generado
            
            qrContainer.innerHTML = `
                <div style="border:1px solid #ddd;padding:10px;display:inline-block;background:white;">
                    <div style="text-align:left;margin-bottom:5px;">
                        <p style="margin:2px 0;font-size:14px;"><strong>Nombre:</strong> ${nombre} ${apellido}</p>
                        <p style="margin:2px 0;font-size:14px;"><strong>${tipoDoc}:</strong> ${documento}</p>
                    </div>
                    <img src="${url}" alt="Código QR" style="width:150px;">
                </div>`;
            
            // Mostrar botón de descarga
            document.getElementById('downloadQRBtn').style.display = 'inline-block';
        });
    }

// Función para descargar QR con foto del usuario (mismo diseño que nuevo.php)
document.getElementById('downloadQRBtn').addEventListener('click', async function() {
    if (!currentQR) return;
    
    const nombre = document.querySelector('input[name="namp"]').value;
    const apellido = document.querySelector('input[name="apep"]').value;
    const documento = document.querySelector('input[name="nhi"]').value;
    const tipoDoc = document.querySelector('select[name="tdocumento"]').value;
    const modalidad = document.querySelector('select[name="modalidad"]')?.value || 'N/A';
    const imgPreview = document.getElementById('img-preview');
    const fotoInput = document.getElementById('fotoperfil');

    // Validar que tipoDoc tenga un valor válido
    if (!tipoDoc || tipoDoc === '' || tipoDoc === 'Seleccione') {
        alert('Por favor seleccione un Tipo de Documento válido');
        return;
    }

    // Función para cargar una imagen
    function loadImage(src) {
        return new Promise((resolve, reject) => {
            const img = new Image();
            img.onload = () => resolve(img);
            img.onerror = reject;
            img.src = src;
        });
    }

    try {
        // Cargar las imágenes del carnet
        const [carnetFrontal, carnetPosterior] = await Promise.all([
            loadImage('../../backend/img/1-carnet.jpg'),
            loadImage('../../backend/img/2-carnet2.jpg')
        ]);

        // Crear canvas para la cara frontal
        const canvasFront = document.createElement('canvas');
        const ctxFront = canvasFront.getContext('2d');
        canvasFront.width = carnetFrontal.width;
        canvasFront.height = carnetFrontal.height;
        
        // Dibujar la imagen del carnet frontal
        ctxFront.drawImage(carnetFrontal, 0, 0);
        
        // Función para procesar y dibujar la foto
        async function procesarFoto() {
            let fotoUsuarioSrc = null;
            
            // Verificar si hay nueva foto seleccionada
            if (fotoInput.files && fotoInput.files[0]) {
                fotoUsuarioSrc = await new Promise((resolve) => {
                    const reader = new FileReader();
                    reader.onload = (e) => resolve(e.target.result);
                    reader.readAsDataURL(fotoInput.files[0]);
                });
            } else if (imgPreview && imgPreview.src && imgPreview.src !== '' && imgPreview.style.display !== 'none') {
                // Si hay foto existente, usarla
                fotoUsuarioSrc = imgPreview.src;
            } else {
                // Si no hay foto, usar la predeterminada
                fotoUsuarioSrc = '../../backend/img/foto-perfil.png';
            }
            
            // Cargar la foto (seleccionada, existente o predeterminada)
            let fotoUsuario = null;
            try {
                fotoUsuario = await loadImage(fotoUsuarioSrc);
            } catch (e) {
                console.warn('No se pudo cargar la foto, intentando con foto predeterminada.', e);
                try {
                    fotoUsuario = await loadImage('../../backend/img/foto-perfil.png');
                } catch (defaultError) {
                    console.warn('No se pudo cargar la foto predeterminada:', defaultError);
                    fotoUsuario = null;
                }
            }

            // Dibujar la foto del usuario centrada (solo si cargó correctamente)
            if (fotoUsuario) {
                
                // Dibujar la foto del usuario centrada
                const targetWidth = 175;
                const targetHeight = 175;
                const centerX = (canvasFront.width / 2) + 10;
                const centerY = 210;

                const imgAspect = fotoUsuario.width / fotoUsuario.height;
                let drawWidth, drawHeight, drawX, drawY;

                if (imgAspect > 1) {
                    drawHeight = targetHeight;
                    drawWidth = drawHeight * imgAspect;
                    if (drawWidth > targetWidth) {
                        drawWidth = targetWidth;
                        drawHeight = drawWidth / imgAspect;
                    }
                } else {
                    drawWidth = targetWidth;
                    drawHeight = drawWidth / imgAspect;
                    if (drawHeight > targetHeight) {
                        drawHeight = targetHeight;
                        drawWidth = drawHeight * imgAspect;
                    }
                }

                drawX = centerX - (drawWidth / 2);
                drawY = centerY - (drawHeight / 2);

                ctxFront.drawImage(fotoUsuario, drawX, drawY, drawWidth, drawHeight);
            }
            
            // Agregar datos del usuario
            ctxFront.fillStyle = '#000000';
            
            const nombreCompleto = `${nombre} ${apellido}`.toUpperCase();
            let fontSize = 18;
            if (nombreCompleto.length > 30) {
                fontSize = 14;
            } else if (nombreCompleto.length > 25) {
                fontSize = 16;
            }
            
            ctxFront.font = `bold ${fontSize}px Arial`;
            ctxFront.textAlign = 'center';
            
            // Usar wrapText para dividir el nombre en múltiples líneas si es necesario
            const maxWidth = 320; // Ancho máximo disponible
            const lineHeight = fontSize + 4; // Espaciado entre líneas
            const startY = 340; // Posición Y inicial
            
            // wrapText retorna la última posición Y usada
            const lastNameY = wrapText(ctxFront, nombreCompleto, canvasFront.width / 2, startY, maxWidth, lineHeight);
            
            // Cédula centrada (con espacio dinámico después del nombre)
            const cedulaY = lastNameY + 30; // 30px de separación desde la última línea del nombre
            ctxFront.font = 'bold 16px Arial';
            ctxFront.fillStyle = '#000000'; // Color negro
            ctxFront.textAlign = 'center';
            ctxFront.fillText(`${tipoDoc.toUpperCase()}: ${documento}`, canvasFront.width / 2, cedulaY);
            
            // Modalidad debajo del documento - centrada (con espacio dinámico)
            const modalidadY = cedulaY + 25; // 25px de separación desde la cédula
            ctxFront.font = 'bold 14px Arial';
            ctxFront.fillStyle = '#000000'; // Color negro
            ctxFront.textAlign = 'center';
            ctxFront.fillText(`${modalidad.toUpperCase()}`, canvasFront.width / 2, modalidadY);
            
            // Crear canvas para la cara posterior
            const canvasBack = document.createElement('canvas');
            const ctxBack = canvasBack.getContext('2d');
            canvasBack.width = carnetPosterior.width;
            canvasBack.height = carnetPosterior.height;
            
            // Dibujar la imagen del carnet posterior
            ctxBack.drawImage(carnetPosterior, 0, 0);
            
            // Cargar y dibujar el QR
            const qrImg = await loadImage(currentQR);
            const qrSize = 180;
            const qrX = (canvasBack.width - qrSize) / 2;
            const qrY = (canvasBack.height - qrSize) / 2 - 50;
            ctxBack.drawImage(qrImg, qrX, qrY, qrSize, qrSize);
            
            // Crear canvas final para combinar ambas caras
            const finalCanvas = document.createElement('canvas');
            const ctxFinal = finalCanvas.getContext('2d');
            finalCanvas.width = canvasFront.width;
            finalCanvas.height = canvasFront.height * 2 + 20;
            
            // Dibujar ambas caras
            ctxFinal.drawImage(canvasFront, 0, 0);
            ctxFinal.drawImage(canvasBack, 0, canvasFront.height + 20);
            
            // Descargar el carnet
            const link = document.createElement('a');
            link.download = `Carnet_${nombre}_${apellido}.png`;
            link.href = finalCanvas.toDataURL('image/png');
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
        
        await procesarFoto();
        
    } catch (error) {
        console.error('Error al generar el carnet:', error);
        alert('Error al generar el carnet. Por favor, inténtelo de nuevo.');
    }
});
</script>

<style>
/* Convertir texto de todos los select a mayúsculas */
select, select option {
    text-transform: uppercase;
}
</style>

</body>
</html>


