<?php 
ob_start(); // Capturar cualquier output no deseado
session_start();
require '../../backend/fpdf/fpdf.php';
date_default_timezone_set('America/Lima');

// Función auxiliar para convertir UTF-8 a ISO-8859-1 (reemplazo de utf8_decode)
function convertText($text) {
    if(empty($text)) return '';
    return mb_convert_encoding($text, 'ISO-8859-1', 'UTF-8');
}

class PDF extends FPDF
{
    function Header()
    {
        $this->Image('../../backend/img/ico.png',15,5,25);
        $this->Image('../../backend/img/neu.png',170,5,25);
        
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(0, 10, convertText('PROGRAMA PERSONA MAYOR'), 0, 1, 'C');
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 5, convertText('Dr(a): '.$_SESSION['name']), 0, 1, 'C');
        $this->Cell(0, 5, convertText('Tel: 3229060608'), 0, 1, 'C');
        $this->Cell(0, 5, convertText('jhon.rubiano@sibate-cundinamarca.gov.co'), 0, 1, 'C');
        $this->Ln(3);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(95,5,convertText('Página ').$this->PageNo().' / {nb}',0,0,'L');
        $this->Cell(95,5,date('d/m/Y | g:i:a'),0,1,'R');
        $this->Cell(0,5,convertText('© Todos los derechos reservados.'),0,0,'C');
    }
    
    function SectionTitle($title) {
        $this->SetFont('Arial', 'B', 11);
        $this->SetFillColor(102, 126, 234);
        $this->SetTextColor(255, 255, 255);
        $this->Cell(0, 8, convertText($title), 0, 1, 'L', true);
        $this->SetTextColor(0, 0, 0);
        $this->Ln(2);
    }
}
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

$pdf->SetAutoPageBreak(true, 20);
$pdf->SetTopMargin(15);
$pdf->SetLeftMargin(10);
$pdf->SetRightMargin(10);

require '../../backend/bd/Conexion.php';
$id = $_GET['id'];

// ========== DATOS DEL USUARIO ==========
$pdf->SectionTitle('DATOS DEL USUARIO');

$stmt = $connect->prepare("SELECT * FROM patients WHERE idpa = :id");
$stmt->execute([':id' => $id]);
$patient = $stmt->fetch(PDO::FETCH_ASSOC);

if($patient) {
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(30, 8, convertText('Documento'),1,0,'C',true);
    $pdf->Cell(50, 8, convertText('Nombre'),1,0,'C',true);
    $pdf->Cell(50, 8, convertText('Apellido'),1,0,'C',true);
    $pdf->Cell(30, 8, convertText('Nacimiento'),1,0,'C',true);
    $pdf->Cell(20, 8, convertText('Sexo'),1,0,'C',true);
    $pdf->Cell(10, 8, convertText('Sangre'),1,1,'C',true);
    
    $pdf->SetFont('Arial','',9);
    $pdf->Cell(30, 8, convertText($patient['numhs']),1,0,'C');
    $pdf->Cell(50, 8, convertText($patient['nompa']),1,0,'L');
    $pdf->Cell(50, 8, convertText($patient['apepa']),1,0,'L');
    $pdf->Cell(30, 8, convertText($patient['cump']),1,0,'C');
    $pdf->Cell(20, 8, convertText($patient['sex']),1,0,'C');
    $pdf->Cell(10, 8, convertText($patient['grup']),1,1,'C');
    $pdf->Ln(5);
}

// ========== VALORACION DEL RIESGO SOCIAL ==========
$pdf->SectionTitle('VALORACION DEL RIESGO SOCIAL');

$riesgo = $connect->prepare("SELECT * FROM valoracionriesgo WHERE idpa = :id ORDER BY fere DESC");
$riesgo->execute([':id' => $id]);
$dataRiesgo = $riesgo->fetchAll(PDO::FETCH_ASSOC);

if(count($dataRiesgo) > 0) {
    foreach($dataRiesgo as $r) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $r['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',7);
        // Fila 1
        $pdf->Cell(30, 5, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['fere']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Enfermedad'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['enfermedadd']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Fuma'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['fuma']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Consumo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['consumo']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Humo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['humo']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Sal'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['sal']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Cocina'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['cocina']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Baño/Vestir'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['vestir']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Día'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['diahoy']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Mes'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['meshoy']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Año'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($r['anohoy']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(30, 5, convertText('Municipio'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(70, 5, convertText($r['municipio']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== TAMIZAJE SALUD ORAL ==========
$pdf->SectionTitle('TAMIZAJE SALUD ORAL');

$oral = $connect->prepare("SELECT * FROM toral WHERE idpa = :id ORDER BY fere DESC");
$oral->execute([':id' => $id]);
$dataOral = $oral->fetchAll(PDO::FETCH_ASSOC);

if(count($dataOral) > 0) {
    foreach($dataOral as $o) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $o['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',7);
        // Fila 1
        $pdf->Cell(35, 5, convertText('Lava dientes'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['lavadientes']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Golpe boca'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['golpeb']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Sangre'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['sangred']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Prótesis'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['protesisd']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Come/sonríe'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['comesonrie']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Limpia boca'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['limpiab']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Dolor'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['dolorc']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Mal olor'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['malolor']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Pérdida dientes'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['perdidadientes']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Maltrato prót.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['maltratoprotesis']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Cicatriz'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['cicatriz']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Boca baño'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(60, 5, convertText($o['bocabano']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Consulta odont.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(155, 5, convertText($o['consultaodont']),1,1,'L');
        
        // Fila 8 - Observaciones
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(35, 5, convertText('Observaciones'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->MultiCell(155, 5, convertText($o['observaciones']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== TAMIZAJE SALUD MENTAL ==========
$pdf->SectionTitle('TAMIZAJE SALUD MENTAL');

$mental = $connect->prepare("SELECT * FROM saludmental WHERE idpa = :id ORDER BY fere DESC");
$mental->execute([':id' => $id]);
$dataMental = $mental->fetchAll(PDO::FETCH_ASSOC);

if(count($dataMental) > 0) {
    foreach($dataMental as $sm) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $sm['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',6);
        // Fila 1
        $pdf->Cell(47, 4, convertText('Maltrato'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['maltrato']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Problemas sueño'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['problemas']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Sentido mal'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['sentidomal']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Arrepentido'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['arrepentido']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Abandono'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['abandono']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Obligado'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['obligado']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Gusto cuerpo'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['cuerpo']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Subido peso'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['subido']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Vómito'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['vomito']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Apetito'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['apetito']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Reconocimiento'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['reconocimiento']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Emborrachado'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['emborracho']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Sustancia'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['sustancia']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Bebida'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['bebida']),1,1,'L');
        
        // Fila 8
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Cigarrillo'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['cigarrillo']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Aconsejado'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['aconsejado']),1,1,'L');
        
        // Fila 9
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Bebida alta'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['bebidaalta']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Dejar beber'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['beberpodido']),1,1,'L');
        
        // Fila 10
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Nervioso'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['aburrido']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Llora frecuente'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['frecuencia']),1,1,'L');
        
        // Fila 11
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Disfrutar activ.'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['actividadesf']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Tomar decisiones'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['tomardecisiones']),1,1,'L');
        
        // Fila 12
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Agresividad'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['agresividad']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Triste'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['ptriste']),1,1,'L');
        
        // Fila 13
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Temeroso'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['ptemeroso']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Acabar vida'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['muerte']),1,1,'L');
        
        // Fila 14
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Hacerse daño'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['dano']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Aislado'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['aislado']),1,1,'L');
        
        // Fila 15
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Motiva seguir'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['motiva1']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Expr. sentimientos'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['sentimiento']),1,1,'L');
        
        // Fila 16
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Contar alguien'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['dificil']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Habilidades'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['habilidad']),1,1,'L');
        
        // Fila 17
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Alegre ánimo'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['alegreyanimo']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Tranquilo relaj.'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['relajadotranquilidad']),1,1,'L');
        
        // Fila 18
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Activo energía'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['activoenergia']),1,0,'L');
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Bien descansado'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(48, 4, convertText($sm['biendescanso']),1,1,'L');
        
        // Fila 19
        $pdf->SetFont('Arial','B',6);
        $pdf->Cell(47, 4, convertText('Momentos interes.'),1,0,'L',true);
        $pdf->SetFont('Arial','',6);
        $pdf->Cell(143, 4, convertText($sm['momentointeresante']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== MEDICAMENTOS ==========
$pdf->SectionTitle('MEDICAMENTOS Y ANTECEDENTES');

$medic = $connect->prepare("SELECT * FROM medicamentos WHERE idpa = :id ORDER BY fere DESC");
$medic->execute([':id' => $id]);
$dataMedic = $medic->fetchAll(PDO::FETCH_ASSOC);

if(count($dataMedic) > 0) {
    foreach($dataMedic as $m) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $m['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',7);
        // Fila 1
        $pdf->Cell(40, 5, convertText('Toma medic.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['tomam']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Cuáles'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['cualm']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Prescripción'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['prescripcion']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Automedica'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['automedicacion']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Quirúrgicos'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['quirurgicos']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Hospitaliz.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['hospitalizacion']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Traumáticos'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['traumaticos']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Hipertensión'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['hipertencion']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Tóxicos'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['toxico']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Alérgicos'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['alergico']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Infecciosos'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['infeccioso']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Enf. Relev.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['enfermedadr']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Úlcera'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['ulcera']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Lepra'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['lepra']),1,1,'L');
        
        // Fila 8
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Diabetes'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['diabetes']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Asma'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['asma']),1,1,'L');
        
        // Fila 9
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Cáncer'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['cancer']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('EPOC'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['epoc']),1,1,'L');
        
        // Fila 10
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Epilepsia'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['epilepsia']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Autoinmunes'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['autoinmunes']),1,1,'L');
        
        // Fila 11
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Ing. Urgenc.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['ingresourgencias']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(40, 5, convertText('Otros'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(55, 5, convertText($m['otrom']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== VALORACION FISICA Y DE SEGUIMIENTO ==========
$pdf->SectionTitle('VALORACION FISICA Y DE SEGUIMIENTO');

$consult = $connect->prepare("SELECT * FROM consult WHERE idpa = :id ORDER BY fere DESC");
$consult->execute([':id' => $id]);
$dataConsult = $consult->fetchAll(PDO::FETCH_ASSOC);

if(count($dataConsult) > 0) {
    foreach($dataConsult as $c) {
        // Separador entre registros
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $c['fere']), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        // Fecha y Motivo
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($c['fere']),1,1,'L');
        
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Motivo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->MultiCell(145, 5, convertText($c['mtcl']),1,'L');
        
        // Fila 1 - Signos Vitales
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Signos Vitales'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['SV']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Frecuencia Card.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['FC']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Frecuencia Resp.'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['FR']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Temperatura'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['TMP']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Talla'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['T']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Peso'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['P']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('IMC'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['IMC']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Presión Arterial'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['PA']),1,1,'L');
        
        // Fila 5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Per. Cefálico'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['PC']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Glucosa'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['GL']),1,1,'L');
        
        // Fila 6
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Tensión Venosa'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['TV']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Tensión Arterial'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['TA']),1,1,'L');
        
        // Fila 7
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Cabeza/Cuello'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['CB_CL']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Neurológico'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['NEU']),1,1,'L');
        
        // Fila 8
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Tórax'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['TRX']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Dorso'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['DOR']),1,1,'L');
        
        // Fila 9
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Abdomen'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['ABD']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Piel'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['PIE']),1,1,'L');
        
        // Fila 10
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Genitourinario'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($c['GUN']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Extremidades'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($c['EXT']),1,1,'L');
        
        // Fila 11
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Limitaciones'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($c['LIM']),1,1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== EVOLUCIONES ==========
$pdf->SectionTitle('EVOLUCIONES PSICOLOGIA/FISIOTERAPIA/ENFERMERIA/EDUC.FISICOS');

$genogram = $connect->prepare("SELECT * FROM genogram WHERE idpa = :id ORDER BY fere DESC");
$genogram->execute([':id' => $id]);
$dataGeno = $genogram->fetchAll(PDO::FETCH_ASSOC);

if(count($dataGeno) > 0) {
    foreach($dataGeno as $g) {
        // Separador entre registros
        $fechaRegistro = (!empty($g['fere']) && $g['fere'] != '0000-00-00 00:00:00') ? $g['fere'] : 'Sin fecha registrada';
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $fechaRegistro), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->Cell(160, 6, convertText($fechaRegistro),1,1,'L');
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Detalle'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->MultiCell(160, 6, convertText($g['detage']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== TRATAMIENTOS ==========
$pdf->SectionTitle('TRATAMIENTO, RESUMEN DE CASO O AMPLIACION DE INFORMACION');

$treatment = $connect->prepare("SELECT * FROM treatment WHERE idpa = :id ORDER BY fere DESC");
$treatment->execute([':id' => $id]);
$dataTreat = $treatment->fetchAll(PDO::FETCH_ASSOC);

if(count($dataTreat) > 0) {
    foreach($dataTreat as $t) {
        // Separador entre registros
        $fechaRegistro = (!empty($t['fere']) && $t['fere'] != '0000-00-00 00:00:00') ? $t['fere'] : 'Sin fecha registrada';
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $fechaRegistro), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->Cell(160, 6, convertText($fechaRegistro),1,1,'L');
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Paciente'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->Cell(160, 6, convertText($t['nompa']),1,1,'L');
        
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(30, 6, convertText('Tratamiento'),1,0,'L',true);
        $pdf->SetFont('Arial','',8);
        $pdf->MultiCell(160, 6, convertText($t['nomtra']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

// ========== FISIOTERAPIA ==========
$pdf->SectionTitle('FISIOTERAPIA');

$fisio = $connect->prepare("SELECT * FROM fisioterapia WHERE idpa = :id AND state = 1 ORDER BY fere DESC");
$fisio->execute([':id' => $id]);
$dataFisio = $fisio->fetchAll(PDO::FETCH_ASSOC);

if(count($dataFisio) > 0) {
    foreach($dataFisio as $f) {
        // Separador entre registros
        $fechaRegistro = (!empty($f['fere']) && $f['fere'] != '0000-00-00 00:00:00') ? $f['fere'] : 'Sin fecha registrada';
        $pdf->SetFillColor(230, 230, 230);
        $pdf->SetFont('Arial','B',8);
        $pdf->Cell(190, 5, convertText('Registro del: ' . $fechaRegistro), 0, 1, 'C', true);
        $pdf->Ln(1);
        
        // Fecha y Usuario
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Fecha'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($fechaRegistro),1,1,'L');
        
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Usuario'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(145, 5, convertText($f['nompa']),1,1,'L');
        
        // Fila 1
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Sentarse/Levantarse'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['sentarse_levantarse']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Flexiones de Brazo'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['flexiones_brazo']),1,1,'L');
        
        // Fila 2
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Flexión de Tronco'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['flexion_tronco']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Juntar Manos Atrás'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['juntar_manos_atras']),1,1,'L');
        
        // Fila 3
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Test de Romberg'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['romberg']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('IPAQ'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['ipaq']),1,1,'L');
        
        // Fila 4
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Alcance Funcional'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(48, 5, convertText($f['alcance_funcional']),1,0,'L');
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Índice de BARTHEL'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(52, 5, convertText($f['barthel']),1,1,'L');
        
        // Fila 5 - Funcionalidad (full width)
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(45, 5, convertText('Funcionalidad'),1,0,'L',true);
        $pdf->SetFont('Arial','',7);
        $pdf->MultiCell(145, 5, convertText($f['funcionalidad']),1,'L');
        
        $pdf->Ln(2);
    }
    $pdf->Ln(3);
} else {
    $pdf->SetFont('Arial','I',9);
    $pdf->Cell(0, 6, convertText('No hay datos registrados'),0,1,'L');
    $pdf->Ln(3);
}

    // Limpiar el buffer de salida antes de generar el PDF
    ob_end_clean();
    $pdf->Output('hogar_abuelos.pdf', 'D');
 ?>