<?php
/**
 * Script para limpiar datos corruptos en la tabla consult
 * Ejecutar una sola vez para limpiar valores "[object HTMLTextAreaElement]"
 */

require_once('../../backend/bd/Conexion.php');

echo "<h2>Limpieza de Datos Corruptos</h2>";
echo "<p>Buscando registros con valores '[object...' en la tabla consult...</p>";

// Campos a limpiar
$campos = ['SV', 'FC', 'FR', 'TMP', 'T', 'P', 'IMC', 'PA', 'PC', 'GL', 'TV', 'TA', 
           'CB_CL', 'NEU', 'TRX', 'DOR', 'ABD', 'PIE', 'GUN', 'EXT', 'LIM', 'mtcl'];

$registrosActualizados = 0;

try {
    // Obtener todos los registros de consult
    $sql = "SELECT * FROM consult WHERE state = 1";
    $stmt = $connect->prepare($sql);
    $stmt->execute();
    $registros = $stmt->fetchAll(PDO::FETCH_OBJ);
    
    echo "<p>Total de registros encontrados: " . count($registros) . "</p>";
    
    foreach ($registros as $registro) {
        $necesitaActualizacion = false;
        $valoresLimpios = [];
        
        // Verificar cada campo
        foreach ($campos as $campo) {
            $valor = $registro->$campo ?? '';
            
            // Si contiene "[object", marcarlo para limpieza
            if (strpos($valor, '[object') !== false) {
                $necesitaActualizacion = true;
                $valoresLimpios[$campo] = ''; // Limpiarlo
                echo "<li>ID {$registro->id}: Campo <strong>{$campo}</strong> contiene valor corrupto: " . htmlspecialchars(substr($valor, 0, 50)) . "...</li>";
            }
        }
        
        // Si hay campos corruptos, actualizar el registro
        if ($necesitaActualizacion) {
            $updateClauses = [];
            $updateValues = [];
            
            foreach ($valoresLimpios as $campo => $valorLimpio) {
                $updateClauses[] = "$campo = ?";
                $updateValues[] = $valorLimpio;
            }
            
            $updateValues[] = $registro->id;
            
            $updateSql = "UPDATE consult SET " . implode(', ', $updateClauses) . " WHERE id = ?";
            $updateStmt = $connect->prepare($updateSql);
            
            if ($updateStmt->execute($updateValues)) {
                $registrosActualizados++;
                echo "<p style='color: green;'>✓ Registro ID {$registro->id} actualizado correctamente</p>";
            } else {
                echo "<p style='color: red;'>✗ Error al actualizar registro ID {$registro->id}</p>";
            }
        }
    }
    
    echo "<hr>";
    echo "<h3>Resultado:</h3>";
    echo "<p><strong>{$registrosActualizados}</strong> registros fueron limpiados.</p>";
    
    if ($registrosActualizados > 0) {
        echo "<p style='color: green; font-weight: bold;'>✓ Limpieza completada exitosamente</p>";
    } else {
        echo "<p style='color: blue;'>✓ No se encontraron datos corruptos. La base de datos está limpia.</p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><a href='historia.php'>← Volver a Historia</a></p>";
?>

<style>
body {
    font-family: Arial, sans-serif;
    padding: 20px;
    background: #f5f5f5;
}
h2, h3 {
    color: #333;
}
li {
    background: #fff;
    padding: 10px;
    margin: 5px 0;
    border-left: 3px solid #ff9800;
    list-style: none;
}
p {
    padding: 5px 0;
}
</style>
