<?php
ob_start();
session_start();

// Incluir sistema de control de acceso
require '../../backend/php/check_access.php';

// Verificar acceso - Psicólogos (Rol 4) o usuarios con permisos personalizados
checkAccess([4]);

require '../../backend/bd/Conexion.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href='https://unpkg.com/boxicons@2.0.9/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="../../backend/css/admin.css?v=7.0">
    <title>Dashboard Psicólogo | Programa Persona Mayor</title>
</head>
<body>
    <!-- SIDEBAR -->
    <?php include '../../backend/php/sidebar_menu.php'; ?>

    <!-- CONTENT -->
    <section id="content">
        <!-- NAVBAR -->
        <nav>
            <i class='bx bx-menu toggle-sidebar'></i>
            <form action="#">
                <div class="form-group">
                    <input type="text" placeholder="Buscar...">
                    <i class='bx bx-search icon'></i>
                </div>
            </form>
            <div class="profile">
                <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?ixid=MnwxMjA3fDB8MHxzZWFyY2h8NHx8cGVvcGxlfGVufDB8fDB8fA%3D%3D&ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=60" alt="">
                <ul class="profile-link">
                    <li><a href="../profile/mostrar.php"><i class='bx bxs-user-circle icon'></i> Perfil</a></li>
                    <li><a href="../salir.php"><i class='bx bxs-log-out-circle'></i> Salir</a></li>
                </ul>
            </div>
        </nav>

        <!-- MAIN -->
        <main>
            <h1 class="title">Bienvenido, <?php echo '<strong>'.htmlspecialchars($_SESSION['name']).'</strong>'; ?></h1>
            <ul class="breadcrumbs">
                <li><a href="dashboard_psicologo.php">Home</a></li>
                <li class="divider">/</li>
                <li><a href="#" class="active">Dashboard Psicólogo</a></li>
            </ul>

            <!-- Dashboard Content -->
            <div class="info-data">
                <div class="card">
                    <div class="head">
                        <div>
                            <h2>Rol: Psicólogo</h2>
                            <p>Panel de Control</p>
                        </div>
                        <i class='bx bx-brain icon'></i>
                    </div>
                    <span class="progress" data-value="100%"></span>
                    <span class="label">Acceso Completo</span>
                </div>

                <div class="card">
                    <div class="head">
                        <div>
                            <h2>Módulos Disponibles</h2>
                            <p>Según tus permisos</p>
                        </div>
                        <i class='bx bx-grid-alt icon'></i>
                    </div>
                    <span class="progress" data-value="<?php 
                        $totalPermisos = 0;
                        $permisosActivos = 0;
                        if(isset($_SESSION['menu_permissions'])) {
                            foreach($_SESSION['menu_permissions'] as $key => $value) {
                                if($key != 'id' && $key != 'user_id') {
                                    $totalPermisos++;
                                    if($value == 1) $permisosActivos++;
                                }
                            }
                            echo round(($permisosActivos / $totalPermisos) * 100);
                        } else {
                            echo '0';
                        }
                    ?>%"></span>
                    <span class="label"><?php echo $permisosActivos; ?> de <?php echo $totalPermisos; ?> módulos activos</span>
                </div>
            </div>

            <!-- Información de Permisos -->
            <div class="data">
                <div class="content-data">
                    <div class="head">
                        <h3>Tus Permisos Configurados</h3>
                    </div>
                    <div class="chart" style="padding: 20px;">
                        <?php if(isset($_SESSION['menu_permissions'])): ?>
                            <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 15px;">
                                <?php
                                $iconos = [
                                    'dashboard' => 'bxs-dashboard',
                                    'remisiones' => 'bxs-file-doc',
                                    'usuarios' => 'bxs-user',
                                    'cursos' => 'bxs-book',
                                    'asistencia' => 'bxs-check-circle',
                                    'profesionales' => 'bxs-user-badge',
                                    'recursos' => 'bxs-folder',
                                    'ajustes' => 'bxs-cog',
                                    'acerca' => 'bxs-info-circle',
                                    'reportes' => 'bxs-report'
                                ];
                                
                                foreach($_SESSION['menu_permissions'] as $key => $value):
                                    if($key != 'id' && $key != 'user_id'):
                                        $icono = isset($iconos[$key]) ? $iconos[$key] : 'bx-circle';
                                        $estado = $value == 1 ? 'Activo' : 'Inactivo';
                                        $color = $value == 1 ? '#27ae60' : '#e74c3c';
                                ?>
                                    <div style="padding: 15px; background: #f8f9fa; border-radius: 8px; border-left: 4px solid <?php echo $color; ?>;">
                                        <i class='bx <?php echo $icono; ?>' style='font-size: 24px; color: <?php echo $color; ?>;'></i>
                                        <h4 style="margin: 10px 0 5px 0; text-transform: capitalize;"><?php echo $key; ?></h4>
                                        <span style="color: <?php echo $color; ?>; font-weight: bold;"><?php echo $estado; ?></span>
                                    </div>
                                <?php 
                                    endif;
                                endforeach; 
                                ?>
                            </div>
                        <?php else: ?>
                            <p>No se encontraron permisos configurados.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>
    </section>

    <script src="../../backend/js/jquery.min.js"></script>
    <script src="../../backend/js/script.js"></script>
</body>
</html>
