<?php
session_start();
require_once('backend/bd/Conexion.php');
global $connect;

echo "<h1>Test de Inserción Directa</h1>";

try {
    // Datos de prueba
    $numhs = '9999999999';
    $nompa = 'TEST';
    $apepa = 'PRUEBA';
    $direc = 'CALLE TEST 123';
    $sex = 'MASCULINO';
    $grup = 'O+';
    $phon = '3001234567';
    $tiene_whatsapp = 'SI';
    $cump = '1990-01-01';
    $modalidad = 'CENTRO DÍA LA PAZ';
    $tusuario = 'NUEVO';
    $tdocumento = 'CC';
    $fexpedicion = '2010-01-01';
    $lexpedicion = 'BOGOTA';
    $ecivil = 'SOLTERO';
    $zona = 'URBANA';
    $barrio = 'CENTRO';
    $correo = 'test@test.com';
    $rbono = 'NO';
    $sisben = 'A1';
    $pensionado = 'NO';
    $tsudadera = 'M';
    $tchaqueta = 'M';
    $tzapatos = '40';
    $talentof = 'NINGUNO';
    $observacionsalida = 'SI';
    $vivecomp = 'SOLO';
    $redapoyo = 'SI';
    $cuidador = 'NINGUNO';
    $pcuidador = 'NINGUNO';
    $zcuidador = 'URBANA';
    $bvccuidador = 'CENTRO';
    $dcuidador = 'CALLE 1';
    $tcuidador = '3001111111';
    $sgsss = 'CONTRIBUTIVO';
    $eps = 'SANITAS';
    $etnia = 'NINGUNO';
    $educacion = 'PRIMARIA';
    $leer = 'SI';
    $utecnologia = 'SI';
    $poblaciond = 'NINGUNO';
    $poblacionoficio = 'NINGUNO';
    $fotoperfil = '';
    
    echo "<p>Intentando insertar documento: <strong>$numhs</strong></p>";
    
    // Verificar si ya existe
    $check = $connect->prepare("SELECT COUNT(*) FROM patients WHERE numhs = :numhs");
    $check->execute([':numhs' => $numhs]);
    $existe = $check->fetchColumn();
    
    if($existe > 0) {
        echo "<div style='background: #fff3cd; color: #856404; padding: 15px; margin: 10px 0;'>";
        echo "⚠️ El documento ya existe. Eliminándolo primero...";
        echo "</div>";
        
        $delete = $connect->prepare("DELETE FROM patients WHERE numhs = :numhs");
        $delete->execute([':numhs' => $numhs]);
    }
    
    $query = "INSERT INTO patients (
        numhs, nompa, apepa, direc, sex, grup, phon, tiene_whatsapp, cump, modalidad, tusuario, 
        tdocumento, fexpedicion, lexpedicion, ecivil, zona, barrio, correo, rbono, sisben, 
        pensionado, tsudadera, tchaqueta, tzapatos, talentof, observacionsalida, vivecomp, 
        redapoyo, cuidador, pcuidador, zcuidador, bvccuidador, dcuidador, tcuidador, sgsss, 
        eps, etnia, educacion, leer, utecnologia, poblaciond, poblacionoficio, fotoperfil,
        corr, username, password, rol, state
    ) VALUES (
        :numhs, :nompa, :apepa, :direc, :sex, :grup, :phon, :tiene_whatsapp, :cump, :modalidad, 
        :tusuario, :tdocumento, :fexpedicion, :lexpedicion, :ecivil, :zona, :barrio, :correo, 
        :rbono, :sisben, :pensionado, :tsudadera, :tchaqueta, :tzapatos, :talentof, 
        :observacionsalida, :vivecomp, :redapoyo, :cuidador, :pcuidador, :zcuidador, 
        :bvccuidador, :dcuidador, :tcuidador, :sgsss, :eps, :etnia, :educacion, :leer, 
        :utecnologia, :poblaciond, :poblacionoficio, :fotoperfil,
        :correo, '', '', '3', '1'
    )";
    
    $statement = $connect->prepare($query);
    
    $data = [
        ':numhs' => $numhs,
        ':nompa' => $nompa,
        ':apepa' => $apepa,
        ':direc' => $direc,
        ':sex' => $sex,
        ':grup' => $grup,
        ':phon' => $phon,
        ':tiene_whatsapp' => $tiene_whatsapp,
        ':cump' => $cump,
        ':modalidad' => $modalidad,
        ':tusuario' => $tusuario,
        ':tdocumento' => $tdocumento,
        ':fexpedicion' => $fexpedicion,
        ':lexpedicion' => $lexpedicion,
        ':ecivil' => $ecivil,
        ':zona' => $zona,
        ':barrio' => $barrio,
        ':correo' => $correo,
        ':rbono' => $rbono,
        ':sisben' => $sisben,
        ':pensionado' => $pensionado,
        ':tsudadera' => $tsudadera,
        ':tchaqueta' => $tchaqueta,
        ':tzapatos' => $tzapatos,
        ':talentof' => $talentof,
        ':observacionsalida' => $observacionsalida,
        ':vivecomp' => $vivecomp,
        ':redapoyo' => $redapoyo,
        ':cuidador' => $cuidador,
        ':pcuidador' => $pcuidador,
        ':zcuidador' => $zcuidador,
        ':bvccuidador' => $bvccuidador,
        ':dcuidador' => $dcuidador,
        ':tcuidador' => $tcuidador,
        ':sgsss' => $sgsss,
        ':eps' => $eps,
        ':etnia' => $etnia,
        ':educacion' => $educacion,
        ':leer' => $leer,
        ':utecnologia' => $utecnologia,
        ':poblaciond' => $poblaciond,
        ':poblacionoficio' => $poblacionoficio,
        ':fotoperfil' => $fotoperfil
    ];
    
    echo "<p>Total de parámetros: " . count($data) . "</p>";
    
    $result = $statement->execute($data);
    
    if($result) {
        $lastId = $connect->lastInsertId();
        echo "<div style='background: #d4edda; color: #155724; padding: 20px; margin: 10px 0; border-radius: 8px;'>";
        echo "<h2>✅ INSERCIÓN EXITOSA!</h2>";
        echo "<p><strong>ID generado:</strong> $lastId</p>";
        echo "<p><strong>Documento:</strong> $numhs</p>";
        echo "</div>";
        
        // Verificar que se insertó
        $verify = $connect->prepare("SELECT * FROM patients WHERE numhs = :numhs");
        $verify->execute([':numhs' => $numhs]);
        $registro = $verify->fetch(PDO::FETCH_ASSOC);
        
        if($registro) {
            echo "<h3>Registro insertado:</h3>";
            echo "<pre>";
            print_r($registro);
            echo "</pre>";
        }
    } else {
        $errorInfo = $statement->errorInfo();
        echo "<div style='background: #f8d7da; color: #721c24; padding: 20px; margin: 10px 0;'>";
        echo "<h2>❌ ERROR EN LA INSERCIÓN</h2>";
        echo "<p><strong>SQLSTATE:</strong> " . $errorInfo[0] . "</p>";
        echo "<p><strong>Error Code:</strong> " . $errorInfo[1] . "</p>";
        echo "<p><strong>Error Message:</strong> " . $errorInfo[2] . "</p>";
        echo "</div>";
    }
    
} catch(PDOException $e) {
    echo "<div style='background: #f8d7da; color: #721c24; padding: 20px; margin: 10px 0;'>";
    echo "<h2>❌ EXCEPCIÓN PDO</h2>";
    echo "<p><strong>Mensaje:</strong> " . $e->getMessage() . "</p>";
    echo "<p><strong>Código:</strong> " . $e->getCode() . "</p>";
    echo "<p><strong>Archivo:</strong> " . $e->getFile() . "</p>";
    echo "<p><strong>Línea:</strong> " . $e->getLine() . "</p>";
    echo "</div>";
}
?>

<style>
    body {
        font-family: Arial, sans-serif;
        padding: 20px;
        background: #f5f5f5;
    }
</style>
