<?php
/**
 * PHPMailer Simplificado para envío de correos
 * Esta es una versión simplificada que usa cURL para enviar correos vía Gmail API
 */

function enviarCorreoGmail($destinatario, $asunto, $mensaje_html, $remitente, $nombre_remitente, $username, $password) {
    // Quitar espacios de la contraseña
    $password = str_replace(' ', '', $password);
    
    // Configuración SMTP de Gmail
    $smtp_host = 'smtp.gmail.com';
    $smtp_port = 587;
    
    // Crear el mensaje RFC 2822
    $boundary = md5(time());
    
    $headers = "From: $nombre_remitente <$remitente>\r\n";
    $headers .= "To: $destinatario\r\n";
    $headers .= "Subject: =?UTF-8?B?" . base64_encode($asunto) . "?=\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    $headers .= "Content-Transfer-Encoding: 8bit\r\n";
    
    $mensaje_completo = $headers . "\r\n" . $mensaje_html;
    
    // Intentar enviar usando fsockopen
    try {
        $socket = fsockopen($smtp_host, $smtp_port, $errno, $errstr, 30);
        
        if (!$socket) {
            error_log("Error conectando a Gmail: $errstr ($errno)");
            return false;
        }
        
        // Leer respuesta inicial
        $response = fgets($socket, 515);
        if (substr($response, 0, 3) != '220') {
            error_log("Error en respuesta inicial: $response");
            fclose($socket);
            return false;
        }
        
        // EHLO
        fputs($socket, "EHLO localhost\r\n");
        $response = fgets($socket, 515);
        
        // Leer todas las capacidades EHLO
        while(substr($response, 3, 1) == '-') {
            $response = fgets($socket, 515);
        }
        
        // STARTTLS
        fputs($socket, "STARTTLS\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '220') {
            error_log("Error en STARTTLS: $response");
            fclose($socket);
            return false;
        }
        
        // Habilitar encriptación TLS
        if (!stream_socket_enable_crypto($socket, true, STREAM_CRYPTO_METHOD_TLS_CLIENT)) {
            error_log("No se pudo habilitar TLS");
            fclose($socket);
            return false;
        }
        
        // EHLO de nuevo después de TLS
        fputs($socket, "EHLO localhost\r\n");
        $response = fgets($socket, 515);
        while(substr($response, 3, 1) == '-') {
            $response = fgets($socket, 515);
        }
        
        // AUTH LOGIN
        fputs($socket, "AUTH LOGIN\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '334') {
            error_log("Error en AUTH LOGIN: $response");
            fclose($socket);
            return false;
        }
        
        // Enviar username
        fputs($socket, base64_encode($username) . "\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '334') {
            error_log("Error en username: $response");
            fclose($socket);
            return false;
        }
        
        // Enviar password
        fputs($socket, base64_encode($password) . "\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '235') {
            error_log("Error en autenticación. Verifica la contraseña de aplicación: $response");
            fclose($socket);
            return false;
        }
        
        // MAIL FROM
        fputs($socket, "MAIL FROM: <$remitente>\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '250') {
            error_log("Error en MAIL FROM: $response");
            fclose($socket);
            return false;
        }
        
        // RCPT TO
        fputs($socket, "RCPT TO: <$destinatario>\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '250') {
            error_log("Error en RCPT TO: $response");
            fclose($socket);
            return false;
        }
        
        // DATA
        fputs($socket, "DATA\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '354') {
            error_log("Error en DATA: $response");
            fclose($socket);
            return false;
        }
        
        // Enviar mensaje
        fputs($socket, $mensaje_completo . "\r\n.\r\n");
        $response = fgets($socket, 515);
        
        if (substr($response, 0, 3) != '250') {
            error_log("Error enviando mensaje: $response");
            fclose($socket);
            return false;
        }
        
        // QUIT
        fputs($socket, "QUIT\r\n");
        fclose($socket);
        
        error_log("✅ Correo enviado exitosamente a: $destinatario");
        return true;
        
    } catch (Exception $e) {
        error_log("Excepción al enviar correo: " . $e->getMessage());
        return false;
    }
}
?>
