<?php
/**
 * Configuración de correo electrónico
 */

// Incluir función mejorada de envío
require_once __DIR__ . '/PHPMailer.php';

// Configuración de Gmail
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'phpasa4@gmail.com');
define('SMTP_PASSWORD', 'mhle vupb vndn phmr');
define('SMTP_FROM_EMAIL', 'phpasa4@gmail.com');
define('SMTP_FROM_NAME', 'Hogar de los Abuelos');

// Método 2: Otro proveedor (Outlook, Yahoo, etc.)
// Para Outlook: smtp.office365.com, puerto 587
// Para Yahoo: smtp.mail.yahoo.com, puerto 587

/**
 * Función para enviar notificación de ubicación
 */
function enviarCorreoUbicacion($destinatario, $nombre, $latitud, $longitud, $fecha_hora) {
    // Verificar que el destinatario sea válido
    if (empty($destinatario) || !filter_var($destinatario, FILTER_VALIDATE_EMAIL)) {
        return false;
    }
    
    $asunto = "📍 Notificación de Ubicación - Hogar de los Abuelos";
    
    // Crear el contenido del correo en HTML
    $mensaje_html = "
    <!DOCTYPE html>
    <html lang='es'>
    <head>
        <meta charset='UTF-8'>
        <style>
            body {
                font-family: Arial, sans-serif;
                line-height: 1.6;
                color: #333;
            }
            .container {
                max-width: 600px;
                margin: 0 auto;
                padding: 20px;
                background-color: #f9f9f9;
            }
            .header {
                background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
                color: white;
                padding: 30px;
                text-align: center;
                border-radius: 10px 10px 0 0;
                border: 2px solid #357abd;
            }
            .header h1 {
                margin: 0;
                font-size: 24px;
            }
            .content {
                background: white;
                padding: 30px;
                border-radius: 0 0 10px 10px;
            }
            .alert-box {
                background: #e3f2fd;
                border: 2px solid #4a90e2;
                border-radius: 8px;
                padding: 20px;
                margin: 20px 0;
                text-align: center;
            }
            .alert-message {
                color: #1565c0;
                font-size: 18px;
                font-weight: 600;
                margin: 15px 0;
                line-height: 1.5;
            }
            .info-box {
                background: #f1f8ff;
                border-left: 4px solid #4a90e2;
                padding: 15px;
                margin: 20px 0;
            }
            .button {
                display: inline-block;
                padding: 15px 40px;
                background: #4a90e2;
                color: white;
                text-decoration: none;
                border-radius: 5px;
                margin: 20px 0;
                font-weight: bold;
                font-size: 16px;
            }
            .footer {
                text-align: center;
                padding: 20px;
                color: #666;
                font-size: 12px;
            }
            .emoji {
                font-size: 64px;
                margin: 10px 0;
            }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <div class='emoji'>⚠️📍</div>
                <h1>Notificación de Ubicación</h1>
            </div>
            <div class='content'>
                <div class='alert-box'>
                    <p style='font-size: 20px; margin: 0;'><strong>Hogar de los Abuelos</strong></p>
                    <p class='alert-message'>
                        Le informamos que se ha registrado<br>
                        la ubicación de:<br>
                        <strong>" . htmlspecialchars($nombre) . "</strong>
                    </p>
                    <p style='font-size: 16px; color: #1565c0; margin-top: 15px;'>
                        📍 Compartimos la ubicación para su conocimiento y seguimiento.
                    </p>
                </div>
                
                <div class='info-box'>
                    <h3 style='margin-top: 0; color: #1565c0;'>📍 Detalles de Ubicación</h3>
                    <p><strong>Fecha y Hora:</strong> " . $fecha_hora . "</p>
                    <p><strong>Coordenadas GPS:</strong></p>
                    <ul>
                        <li>Latitud: " . number_format($latitud, 6) . "</li>
                        <li>Longitud: " . number_format($longitud, 6) . "</li>
                    </ul>
                </div>
                
                <p style='text-align: center;'>
                    <a href='https://www.google.com/maps?q=" . $latitud . "," . $longitud . "' class='button'>
                        🗺️ Ver Ubicación en el Mapa
                    </a>
                </p>
                
                <p style='color: #1565c0; font-size: 14px; margin-top: 30px; text-align: center;'>
                    👍 Puede revisar la ubicación haciendo clic en el botón de arriba.
                </p>
            </div>
            <div class='footer'>
                <p>Hogar de los Abuelos © " . date('Y') . "</p>
                <p style='color: #4a90e2; font-weight: 600;'>Sistema de Registro de Ubicación</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    // Versión en texto plano
    $mensaje_texto = "
📍 NOTIFICACIÓN DE UBICACIÓN

Hogar de los Abuelos

Le informamos que se ha registrado la ubicación de $nombre.

DETALLES DE UBICACIÓN:
Fecha y Hora: $fecha_hora
Latitud: " . number_format($latitud, 6) . "
Longitud: " . number_format($longitud, 6) . "

Ver ubicación en Google Maps:
https://www.google.com/maps?q=$latitud,$longitud

👍 Puede revisar la ubicación haciendo clic en el enlace de arriba.

---
Hogar de los Abuelos © " . date('Y') . "
Sistema de Registro de Ubicación
    ";
    
    // Usar la función mejorada de PHPMailer.php
    return enviarCorreoGmail(
        $destinatario,
        $asunto,
        $mensaje_html,
        SMTP_FROM_EMAIL,
        SMTP_FROM_NAME,
        SMTP_USERNAME,
        SMTP_PASSWORD
    );
}

?>
