<?php
require 'backend/bd/Conexion.php';

echo "<h2>Estructura de la tabla menu_permissions</h2>";

// Obtener columnas
$columns = $connect->query("SHOW COLUMNS FROM menu_permissions")->fetchAll(PDO::FETCH_ASSOC);

echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
echo "<tr style='background: #667eea; color: white;'>";
echo "<th>Columna</th><th>Tipo</th><th>Nulo</th><th>Default</th>";
echo "</tr>";

foreach($columns as $col) {
    echo "<tr>";
    echo "<td><strong>" . $col['Field'] . "</strong></td>";
    echo "<td>" . $col['Type'] . "</td>";
    echo "<td>" . $col['Null'] . "</td>";
    echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
    echo "</tr>";
}

echo "</table>";

echo "<h3>Columnas que deberían existir para los submenús:</h3>";
$columnasNecesarias = [
    'remisiones_todas',
    'remisiones_nueva',
    'remisiones_calendario',
    'usuarios_lista',
    'usuarios_historial',
    'usuarios_documentos',
    'cursos_registro',
    'cursos_inscripcion',
    'cursos_asistencia',
    'profesionales_lista',
    'profesionales_historial',
    'recursos_enfermera',
    'recursos_laboratorios',
    'ajustes_config',
    'ajustes_idioma',
    'ajustes_base_datos'
];

$columnasExistentes = array_column($columns, 'Field');
$columnasFaltantes = array_diff($columnasNecesarias, $columnasExistentes);

if(count($columnasFaltantes) > 0) {
    echo "<div style='background: #fee; padding: 15px; border-radius: 8px; margin: 20px 0;'>";
    echo "<h4 style='color: #c33; margin-top: 0;'>❌ Columnas faltantes:</h4>";
    echo "<ul>";
    foreach($columnasFaltantes as $col) {
        echo "<li><code>$col</code></li>";
    }
    echo "</ul>";
    echo "<p><strong>Estas columnas deben agregarse a la tabla para que los submenús funcionen.</strong></p>";
    echo "</div>";
    
    // Generar SQL para agregar columnas
    echo "<h3>SQL para agregar las columnas faltantes:</h3>";
    echo "<textarea style='width: 100%; height: 200px; font-family: monospace; padding: 10px;'>";
    foreach($columnasFaltantes as $col) {
        echo "ALTER TABLE menu_permissions ADD COLUMN $col TINYINT(1) DEFAULT 0;\n";
    }
    echo "</textarea>";
} else {
    echo "<div style='background: #e6f7ee; padding: 15px; border-radius: 8px;'>";
    echo "<p style='color: #155724; margin: 0;'><strong>✅ Todas las columnas necesarias existen</strong></p>";
    echo "</div>";
}
?>
