<?php
session_start();
require_once('backend/bd/Conexion.php');
global $connect;

echo "<h1>Últimos 10 registros en la tabla patients</h1>";

try {
    $stmt = $connect->prepare("SELECT idpa, numhs, nompa, apepa, cump, modalidad, correo FROM patients ORDER BY idpa DESC LIMIT 10");
    $stmt->execute();
    $registros = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if(count($registros) > 0) {
        echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background: #667eea; color: white;'>
                <th>ID</th>
                <th>Documento</th>
                <th>Nombres</th>
                <th>Apellidos</th>
                <th>Fecha Nacimiento</th>
                <th>Modalidad</th>
                <th>Correo</th>
              </tr>";
        
        foreach($registros as $reg) {
            echo "<tr>";
            echo "<td>" . $reg['idpa'] . "</td>";
            echo "<td>" . $reg['numhs'] . "</td>";
            echo "<td>" . $reg['nompa'] . "</td>";
            echo "<td>" . $reg['apepa'] . "</td>";
            echo "<td>" . $reg['cump'] . "</td>";
            echo "<td>" . $reg['modalidad'] . "</td>";
            echo "<td>" . ($reg['correo'] ?? 'N/A') . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
        
        echo "<h2 style='color: green;'>Total de registros mostrados: " . count($registros) . "</h2>";
        
        // Contar total de registros
        $stmtCount = $connect->query("SELECT COUNT(*) as total FROM patients");
        $total = $stmtCount->fetch(PDO::FETCH_ASSOC);
        echo "<h2 style='color: blue;'>Total de registros en la tabla: " . $total['total'] . "</h2>";
    } else {
        echo "<p style='color: red; font-size: 20px;'>No hay registros en la tabla patients</p>";
    }
    
    // Verificar estructura de la tabla
    echo "<h2>Estructura de la tabla patients</h2>";
    $stmt2 = $connect->query("DESCRIBE patients");
    $columnas = $stmt2->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr style='background: #764ba2; color: white;'>
            <th>Campo</th>
            <th>Tipo</th>
            <th>Null</th>
            <th>Key</th>
            <th>Default</th>
          </tr>";
    
    foreach($columnas as $col) {
        echo "<tr>";
        echo "<td>" . $col['Field'] . "</td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
?>

<style>
    body {
        font-family: Arial, sans-serif;
        padding: 20px;
        background: #f5f5f5;
    }
    table {
        background: white;
        margin: 20px 0;
    }
    tr:nth-child(even) {
        background: #f9f9f9;
    }
</style>
